/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.MinCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinCountPropertyShape
extends PathPropertyShape {
    private long minCount;
    private static final Logger logger = LoggerFactory.getLogger(MinCountPropertyShape.class);
    private boolean optimizeWhenNoStatementsRemoved = true;

    MinCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Long minCount) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.minCount = minCount;
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        PlanNode filteredStatements;
        UnionNode topNode;
        if (this.deactivated) {
            return null;
        }
        assert (!negateSubPlans) : "There are no subplans!";
        assert (!negateThisPlan);
        assert (this.hasOwnPath());
        if (overrideTargetNode != null) {
            BulkedExternalLeftOuterJoin allStatements = new BulkedExternalLeftOuterJoin(overrideTargetNode.getPlanNode(), connectionsGroup.getBaseConnection(), this.getPath().getQuery("?a", "?c", null), false, null, "?a", "?c");
            GroupByCount groupBy = new GroupByCount(allStatements);
            PlanNode filteredStatements2 = new MinCountFilter(groupBy, this.minCount).getFalseNode(UnBufferedPlanNode.class);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements2, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(filteredStatements2, this);
        }
        if (this.minCount == 1L && connectionsGroup.getStats().isBaseSailEmpty()) {
            String query = this.nodeShape.getQuery("?a", "?b", null);
            String query1 = this.getPath().getQuery("?a", "?d", null);
            String negationQuery = query + "\n FILTER(NOT EXISTS{" + query1 + "})";
            PlanNode select = new Select(connectionsGroup.getAddedStatements(), negationQuery, "?a");
            select = new ModifyTuple(select, a -> {
                a.line.add(SimpleValueFactory.getInstance().createLiteral(0));
                return a;
            });
            select = new AggregateIteratorTypeOverride(select);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(select, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(select, this);
        }
        if (!this.optimizeWhenNoStatementsRemoved || connectionsGroup.getStats().hasRemoved()) {
            Unique planRemovedStatements = new Unique(new TrimTuple(this.getPlanRemovedStatements(connectionsGroup, null), 0, 1));
            PlanNode filteredPlanRemovedStatements = this.nodeShape.getTargetFilter(connectionsGroup.getBaseConnection(), planRemovedStatements);
            PlanNode planAddedStatements = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
            UnionNode mergeNode = new UnionNode(planAddedStatements, filteredPlanRemovedStatements);
            Unique unique = new Unique(mergeNode);
            PlanNode planAddedStatements1 = this.getPlanAddedStatements(connectionsGroup, null);
            planAddedStatements1 = this.nodeShape.getTargetFilter(connectionsGroup.getBaseConnection(), planAddedStatements1);
            topNode = new UnionNode(unique, planAddedStatements1);
        } else {
            PlanNode planAddedForShape = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
            PlanNode addedByPath = this.getPlanAddedStatements(connectionsGroup, null);
            addedByPath = this.nodeShape.getTargetFilter(connectionsGroup.getBaseConnection(), addedByPath);
            topNode = new UnionNode(planAddedForShape, addedByPath);
        }
        GroupByCount groupBy = new GroupByCount(topNode);
        PlanNode minCountFilter = filteredStatements = new MinCountFilter(groupBy, this.minCount).getFalseNode(UnBufferedPlanNode.class);
        Unique trimTuple = new Unique(new TrimTuple(minCountFilter, 0, 1));
        BulkedExternalLeftOuterJoin bulkedExternalLeftOuterJoin2 = new BulkedExternalLeftOuterJoin(trimTuple, connectionsGroup.getBaseConnection(), this.getPath().getQuery("?a", "?c", null), false, null, "?a", "?c");
        GroupByCount groupBy2 = new GroupByCount(bulkedExternalLeftOuterJoin2);
        PlanNode filteredStatements2 = new MinCountFilter(groupBy2, this.minCount).getFalseNode(UnBufferedPlanNode.class);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(filteredStatements2, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(filteredStatements2, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MinCountConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MinCountPropertyShape that = (MinCountPropertyShape)o;
        return this.minCount == that.minCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minCount);
    }

    public String toString() {
        return "MinCountPropertyShape{minCount=" + this.minCount + ", path=" + this.getPath() + '}';
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        PlanNode plan = this.nodeShape.getPlanAddedStatements(connectionsGroup, null);
        plan = new UnionNode(plan, this.nodeShape.getPlanRemovedStatements(connectionsGroup, null));
        Path path = this.getPath();
        if (path != null) {
            plan = new UnionNode(plan, this.getPlanAddedStatements(connectionsGroup, null));
            plan = new UnionNode(plan, this.getPlanRemovedStatements(connectionsGroup, null));
        }
        plan = new Unique(new TrimTuple(plan, 0, 1));
        return this.nodeShape.getTargetFilter(connectionsGroup.getBaseConnection(), plan);
    }
}

