/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlanGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.QueryGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.RequiresEvalutation;
import org.eclipse.rdf4j.sail.shacl.AST.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.AST.TargetClass;
import org.eclipse.rdf4j.sail.shacl.AST.TargetNode;
import org.eclipse.rdf4j.sail.shacl.AST.TargetObjectsOf;
import org.eclipse.rdf4j.sail.shacl.AST.TargetSubjectsOf;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;

public class NodeShape
implements PlanGenerator,
RequiresEvalutation,
QueryGenerator {
    private Resource id;
    private List<PathPropertyShape> propertyShapes = Collections.emptyList();
    private List<PathPropertyShape> nodeShapes = Collections.emptyList();

    public NodeShape(Resource id, SailRepositoryConnection connection, boolean deactivated) {
        this.id = id;
        if (!deactivated) {
            this.propertyShapes = PropertyShape.Factory.getPropertyShapes(id, connection, this);
            this.nodeShapes = PropertyShape.Factory.getPropertyShapesInner(connection, this, id, null);
        }
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        Select node = new Select(connectionsGroup.getBaseConnection(), this.getQuery("?a", "?c", null), "?a", "?c");
        return new Unique(new TrimTuple(node, 0, 1));
    }

    @Override
    public PlanNode getPlanAddedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode node = connectionsGroup.getCachedNodeFor(new Select(connectionsGroup.getAddedStatements(), this.getQuery("?a", "?c", null), "?a", "?c"));
        return new Unique(new TrimTuple(node, 0, 1));
    }

    @Override
    public PlanNode getPlanRemovedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode node = connectionsGroup.getCachedNodeFor(new Select(connectionsGroup.getRemovedStatements(), this.getQuery("?a", "?c", null), "?a", "?c"));
        return new Unique(new TrimTuple(node, 0, 1));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Path> getPaths() {
        throw new IllegalStateException();
    }

    public Stream<PlanNode> generatePlans(ConnectionsGroup connectionsGroup, NodeShape nodeShape, boolean printPlans, boolean validateEntireBaseSail) {
        SailConnection removedStatements;
        SailConnection addedStatements;
        PlanNodeProvider overrideTargetNodeBufferedSplitter;
        if (validateEntireBaseSail) {
            if (connectionsGroup.getSail().isCacheSelectNodes()) {
                PlanNode overrideTargetNode = this.getPlan(connectionsGroup, printPlans, null, false, false);
                overrideTargetNodeBufferedSplitter = new BufferedSplitter(overrideTargetNode);
            } else {
                overrideTargetNodeBufferedSplitter = () -> this.getPlan(connectionsGroup, printPlans, null, false, false);
            }
            addedStatements = connectionsGroup.getBaseConnection();
            removedStatements = connectionsGroup.getBaseConnection();
        } else {
            overrideTargetNodeBufferedSplitter = null;
            addedStatements = connectionsGroup.getAddedStatements();
            removedStatements = connectionsGroup.getRemovedStatements();
        }
        Stream<PlanNode> propertyShapesPlans = this.convertToPlan(this.propertyShapes, connectionsGroup, nodeShape, printPlans, overrideTargetNodeBufferedSplitter, addedStatements, removedStatements);
        Stream<PlanNode> nodeShapesPlans = this.convertToPlan(this.nodeShapes, connectionsGroup, nodeShape, printPlans, overrideTargetNodeBufferedSplitter, addedStatements, removedStatements);
        return Stream.concat(propertyShapesPlans, nodeShapesPlans);
    }

    private Stream<PlanNode> convertToPlan(List<PathPropertyShape> propertyShapes, ConnectionsGroup connectionsGroup, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNodeBufferedSplitter, SailConnection addedStatements, SailConnection removedStatements) {
        return propertyShapes.stream().filter(propertyShape -> propertyShape.requiresEvaluation(addedStatements, removedStatements)).map(propertyShape -> propertyShape.getPlan(connectionsGroup, printPlans, overrideTargetNodeBufferedSplitter, false, false));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return true;
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return subjectVariable + " ?fj42798yfhf2j4 " + objectVariable + " .";
    }

    public Resource getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public PlanNode getTargetFilter(SailConnection shaclSailConnection, PlanNode parent) {
        return parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeShape nodeShape = (NodeShape)o;
        return this.id.equals(nodeShape.id) && this.propertyShapes.equals(nodeShape.propertyShapes) && this.nodeShapes.equals(nodeShape.nodeShapes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.propertyShapes, this.nodeShapes);
    }

    public static class Factory {
        public static List<NodeShape> getShapes(SailRepositoryConnection connection, ShaclSail sail) {
            try (Stream stream = connection.getStatements(null, RDF.TYPE, (Value)SHACL.NODE_SHAPE, new Resource[0]).stream();){
                List<NodeShape> list = stream.map(Statement::getSubject).flatMap(shapeId -> {
                    ArrayList<NodeShape> propertyShapes = new ArrayList<NodeShape>(2);
                    ShaclProperties shaclProperties = new ShaclProperties((Resource)shapeId, connection);
                    if (!shaclProperties.targetClass.isEmpty()) {
                        propertyShapes.add(new TargetClass((Resource)shapeId, connection, shaclProperties.deactivated, shaclProperties.targetClass));
                    }
                    if (!shaclProperties.targetNode.isEmpty()) {
                        propertyShapes.add(new TargetNode((Resource)shapeId, connection, shaclProperties.deactivated, shaclProperties.targetNode));
                    }
                    if (!shaclProperties.targetSubjectsOf.isEmpty()) {
                        propertyShapes.add(new TargetSubjectsOf((Resource)shapeId, connection, shaclProperties.deactivated, shaclProperties.targetSubjectsOf));
                    }
                    if (!shaclProperties.targetObjectsOf.isEmpty()) {
                        propertyShapes.add(new TargetObjectsOf((Resource)shapeId, connection, shaclProperties.deactivated, shaclProperties.targetObjectsOf));
                    }
                    if (sail.isUndefinedTargetValidatesAllSubjects() && propertyShapes.isEmpty()) {
                        propertyShapes.add(new NodeShape((Resource)shapeId, connection, shaclProperties.deactivated));
                    }
                    return propertyShapes.stream();
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return list;
            }
        }
    }
}

