/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class BulkedExternalLeftOuterJoin
extends AbstractBulkJoinPlanNode {
    private final SailConnection connection;
    private final PlanNode leftNode;
    private final ParsedQuery parsedQuery;
    private final boolean skipBasedOnPreviousConnection;
    private final SailConnection previousStateConnection;
    private boolean printed = false;

    public BulkedExternalLeftOuterJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, String ... variables) {
        this.leftNode = leftNode;
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        this.parsedQuery = queryParserFactory.getParser().parseQuery("select * where { VALUES (?a) {}" + query + "} order by ?a", null);
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
        this.previousStateConnection = previousStateConnection;
        this.variables = variables;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            ArrayDeque<Tuple> left;
            ArrayDeque<Tuple> right;
            CloseableIteration<Tuple, SailException> leftNodeIterator;
            {
                this.left = new ArrayDeque();
                this.right = new ArrayDeque();
                this.leftNodeIterator = BulkedExternalLeftOuterJoin.this.leftNode.iterator();
            }

            private void calculateNext() {
                if (!this.left.isEmpty()) {
                    return;
                }
                while (this.left.size() < 200 && this.leftNodeIterator.hasNext()) {
                    this.left.addFirst((Tuple)this.leftNodeIterator.next());
                }
                if (this.left.isEmpty()) {
                    return;
                }
                BulkedExternalLeftOuterJoin.this.runQuery(this.left, this.right, BulkedExternalLeftOuterJoin.this.connection, BulkedExternalLeftOuterJoin.this.parsedQuery, BulkedExternalLeftOuterJoin.this.skipBasedOnPreviousConnection, BulkedExternalLeftOuterJoin.this.previousStateConnection, BulkedExternalLeftOuterJoin.this.variables);
            }

            @Override
            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return !this.left.isEmpty();
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.calculateNext();
                if (!this.left.isEmpty()) {
                    Tuple leftPeek = this.left.peekLast();
                    Tuple joined = null;
                    if (!this.right.isEmpty()) {
                        Tuple rightPeek = this.right.peekLast();
                        if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                            joined = TupleHelper.join(leftPeek, rightPeek);
                            this.right.removeLast();
                            Tuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 == null || !rightPeek2.line.get(0).equals(leftPeek.line.get(0))) {
                                this.left.removeLast();
                            }
                        }
                    }
                    if (joined != null) {
                        return joined;
                    }
                    this.left.removeLast();
                    return leftPeek;
                }
                return null;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        if (this.skipBasedOnPreviousConnection) {
            stringBuilder.append(System.identityHashCode(this.previousStateConnection) + " -> " + this.getId() + " [label=\"skip if not present\"]").append("\n");
        }
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
    }

    public String toString() {
        return "BulkedExternalLeftOuterJoin{parsedQuery=" + this.parsedQuery.getSourceString().replace("\n", "  ") + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.leftNode.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.leftNode.receiveLogger(validationExecutionLogger);
    }
}

