/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.SimplePath;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.results.ModelInterface;

public class ValidationResult
implements ModelInterface {
    private Resource id = SimpleValueFactory.getInstance().createBNode();
    private SourceConstraintComponent sourceConstraintComponent;
    private PropertyShape sourceShape;
    private Path path;
    private ValidationResult detail;
    private Value focusNode;

    public ValidationResult(PropertyShape sourceShape, Value focusNode) {
        this.sourceShape = sourceShape;
        this.focusNode = focusNode;
        this.sourceConstraintComponent = sourceShape.getSourceConstraintComponent();
        if (sourceShape instanceof PathPropertyShape) {
            this.path = ((PathPropertyShape)sourceShape).getPath();
        }
    }

    public void setDetail(ValidationResult detail) {
        this.detail = detail;
    }

    public ValidationResult getDetail() {
        return this.detail;
    }

    public List<ValidationResult> getDetails() {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        ValidationResult temp = this.detail;
        while (temp != null) {
            validationResults.add(temp);
            temp = temp.detail;
        }
        return validationResults;
    }

    @Override
    public Model asModel(Model model) {
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.VALIDATION_RESULT, new Resource[0]);
        model.add(this.getId(), SHACL.FOCUS_NODE, this.getFocusNode(), new Resource[0]);
        model.add(this.getId(), SHACL.SOURCE_CONSTRAINT_COMPONENT, (Value)this.getSourceConstraintComponent().getIri(), new Resource[0]);
        model.add(this.getId(), SHACL.SOURCE_SHAPE, (Value)this.getSourceShapeResource(), new Resource[0]);
        if (this.getPath() != null) {
            model.add(this.getId(), SHACL.RESULT_PATH, (Value)((SimplePath)this.getPath()).getPath(), new Resource[0]);
        }
        if (this.detail != null) {
            model.add(this.getId(), SHACL.DETAIL, (Value)this.detail.getId(), new Resource[0]);
            this.detail.asModel(model);
        }
        return model;
    }

    private Path getPath() {
        return this.path;
    }

    public Resource getSourceShapeResource() {
        return this.sourceShape.getId();
    }

    private Value getFocusNode() {
        return this.focusNode;
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    public SourceConstraintComponent getSourceConstraintComponent() {
        return this.sourceConstraintComponent;
    }

    public String toString() {
        return "ValidationResult{sourceConstraintComponent=" + (Object)((Object)this.sourceConstraintComponent) + ", sourceShape=" + this.sourceShape + ", path=" + this.path + ", detail=" + this.detail + ", focusNode=" + this.focusNode + '}';
    }
}

