/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.cache.behaviours;

import com.google.inject.Inject;
import java.lang.reflect.Modifier;
import net.enilink.composition.asm.AsmUtils;
import net.enilink.composition.asm.BehaviourClassNode;
import net.enilink.composition.asm.BehaviourMethodProcessor;
import net.enilink.composition.asm.DependsOn;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.Types;
import net.enilink.composition.asm.util.BehaviourMethodGenerator;
import net.enilink.composition.cache.IPropertyCache;
import net.enilink.composition.cache.annotations.Cacheable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;

@DependsOn(value={BehaviourMethodProcessor.class})
public class CacheBehaviourMethodProcessor
implements BehaviourMethodProcessor,
Opcodes,
Types {
    public boolean appliesTo(BehaviourClassNode classNode, ExtendedMethod method) {
        return AsmUtils.findAnnotation(Cacheable.class, (java.lang.reflect.Method)method.getOverriddenMethod()) != null && !method.getOverriddenMethod().getReturnType().equals(Void.TYPE);
    }

    public boolean implementsMethod(Class<?> targetClass, java.lang.reflect.Method method) {
        return !Modifier.isAbstract(method.getModifiers()) && AsmUtils.findAnnotation(Cacheable.class, (java.lang.reflect.Method)method) != null && !method.getReturnType().equals(Void.TYPE);
    }

    public void initialize(BehaviourClassNode classNode) throws Exception {
        FieldNode cacheField = new FieldNode(2, "cache", Type.getDescriptor(IPropertyCache.class), null, null);
        cacheField.visitAnnotation(Type.getDescriptor(Inject.class), true);
        classNode.fields.add(cacheField);
    }

    public void process(BehaviourClassNode classNode, ExtendedMethod method) throws Exception {
        boolean isAbstract = method.instructions.size() == 0;
        Type returnType = Type.getReturnType((String)method.desc);
        Cacheable cacheable = (Cacheable)AsmUtils.findAnnotation(Cacheable.class, (java.lang.reflect.Method)method.getOverriddenMethod());
        String cacheKey = cacheable.key().isEmpty() ? method.name : cacheable.key();
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(method);
        if (!isAbstract) {
            gen.pushInsns();
        }
        gen.loadThis();
        gen.getField("cache", Type.getType(IPropertyCache.class));
        gen.loadBean();
        gen.push(cacheKey);
        gen.loadArgArray();
        gen.invokeInterface(Type.getType(IPropertyCache.class), new Method("get", OBJECT_TYPE, new Type[]{OBJECT_TYPE, OBJECT_TYPE, Type.getType(Object[].class)}));
        gen.dup();
        Label isNull = gen.newLabel();
        gen.ifNull(isNull);
        gen.unbox(returnType);
        gen.returnValue();
        gen.mark(isNull);
        gen.pop();
        if (!isAbstract) {
            gen.peekInsns().insertBefore(gen.peekInsns().getFirst(), gen.instructions);
            gen.instructions.clear();
        }
        int result = gen.newLocal(returnType);
        if (!isAbstract) {
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (!(insn.getOpcode() >= 172 & insn.getOpcode() <= 176)) continue;
                gen.pushInsns();
                this.storeValue(result, returnType, cacheKey, gen);
                gen.peekInsns().insertBefore(insn, gen.instructions);
                gen.instructions.clear();
            }
        } else {
            gen.loadThis();
            gen.loadArgs();
            gen.invokeSpecial(classNode.getParentType(), new Method(method.name, method.desc));
            this.storeValue(result, returnType, cacheKey, gen);
            gen.returnValue();
        }
    }

    private void storeValue(int resultVar, Type type, String cacheKey, BehaviourMethodGenerator gen) {
        gen.storeLocal(resultVar);
        gen.loadThis();
        gen.getField("cache", Type.getType(IPropertyCache.class));
        gen.loadBean();
        gen.push(cacheKey);
        gen.loadArgArray();
        gen.loadLocal(resultVar);
        gen.box(type);
        gen.invokeInterface(Type.getType(IPropertyCache.class), new Method("put", OBJECT_TYPE, new Type[]{OBJECT_TYPE, OBJECT_TYPE, Type.getType(Object[].class), OBJECT_TYPE}));
        gen.unbox(type);
    }
}

