/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util;

import net.enilink.commons.util.IOpener;
import net.enilink.commons.util.Log;
import net.enilink.commons.util.extensions.RegistryFactoryHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class CommonsUtilPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "net.enilink.commons.util";
    private static CommonsUtilPlugin plugin;
    private static Log logHelper;

    public void start(BundleContext context) throws Exception {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
    }

    public static CommonsUtilPlugin getDefault() {
        return plugin;
    }

    public static boolean openResource(String openerId, Object root, Object resource) {
        IExtensionPoint extensionPoint = RegistryFactoryHelper.getRegistry().getExtensionPoint(PLUGIN_ID, "openers");
        if (extensionPoint == null) {
            CommonsUtilPlugin.logErrorMessage("Unable to find opener. Extension point: openers not found");
            return false;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        for (int j = 0; j < configElements.length; ++j) {
            String strId = configElements[j].getAttribute("id");
            if (!openerId.equals(strId)) continue;
            targetElement = configElements[j];
            break;
        }
        if (targetElement == null) {
            CommonsUtilPlugin.logErrorMessage("Unable to find opener: " + openerId);
            return false;
        }
        try {
            IOpener opener = (IOpener)targetElement.createExecutableExtension("class");
            if (opener.canOpen(root, resource)) {
                return opener.open(root, resource);
            }
        }
        catch (CoreException e) {
            CommonsUtilPlugin.log(e);
        }
        return false;
    }

    public static void log(IStatus status) {
        logHelper.log(status);
    }

    public static void logErrorMessage(String message) {
        CommonsUtilPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            CommonsUtilPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 0, message, null);
        multi.add(status);
        CommonsUtilPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        CommonsUtilPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, "Internal error", e));
    }

    static {
        logHelper = new Log(CommonsUtilPlugin.class);
    }
}

