/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.enilink.commons.util.IPartialOrderProvider;

public class LinearExtension<T> {
    IPartialOrderProvider<T> partialOrderProvider;

    public static void main(String ... args) {
        IPartialOrderProvider<String> p = new IPartialOrderProvider<String>(){
            String[] elements = new String[]{"a1", "a2", "a3", "b1", "b2"};

            @Override
            public Collection<String> getElements() {
                return Arrays.asList(this.elements);
            }

            @Override
            public Collection<String> getSuccessors(String element) {
                if (element == this.elements[0]) {
                    return Arrays.asList(this.elements[1]);
                }
                if (element == this.elements[1]) {
                    return Arrays.asList(this.elements[2]);
                }
                if (element == this.elements[3]) {
                    return Arrays.asList(this.elements[4]);
                }
                return Collections.emptyList();
            }
        };
        LinearExtension<String> leGen = new LinearExtension<String>(p);
        leGen.createLinearExtension();
    }

    public LinearExtension(IPartialOrderProvider<T> partialOrderProvider) {
        this.partialOrderProvider = partialOrderProvider;
    }

    private void addSuccessorsToMinElements(T element, Map<T, Integer> predCount, List<T> minElements) {
        for (T succ : this.partialOrderProvider.getSuccessors(element)) {
            Integer inDegree = predCount.remove(succ);
            if (inDegree == null) continue;
            Integer n = inDegree;
            Integer n2 = inDegree = Integer.valueOf(inDegree - 1);
            if (inDegree == 0) {
                minElements.add(succ);
                continue;
            }
            predCount.put(succ, inDegree);
        }
    }

    public List<T> createLinearExtension() {
        return this.createLinearExtension(new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    public List<T> createLinearExtension(List<T> list) {
        HashMap<Object, Integer> predCount = new HashMap<Object, Integer>();
        LinkedList minElements = new LinkedList();
        for (T t : this.partialOrderProvider.getElements()) {
            predCount.put(t, 0);
        }
        for (Object object : predCount.keySet()) {
            for (Object succ : this.partialOrderProvider.getSuccessors(object)) {
                Integer p;
                if (object.equals(succ) || (p = (Integer)predCount.get(succ)) == null) continue;
                Integer n = p;
                Integer n2 = p = Integer.valueOf(p + 1);
                predCount.put(succ, p);
            }
        }
        for (Map.Entry entry : predCount.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            minElements.add(entry.getKey());
        }
        while (!minElements.isEmpty()) {
            void var5_13;
            Object firstElement = minElements.remove(0);
            Object var5_11 = null;
            if (minElements.isEmpty()) {
                list.add(firstElement);
            } else {
                Object e = minElements.remove(0);
                list.add(firstElement);
                list.add(e);
            }
            this.addSuccessorsToMinElements(firstElement, predCount, minElements);
            if (var5_13 == null) continue;
            this.addSuccessorsToMinElements(var5_13, predCount, minElements);
        }
        return list;
    }
}

