/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.Map;
import net.enilink.commons.util.ValueType;

public class ValueUtils {
    protected Map<Class<?>, ValueType> typeMap = new IdentityHashMap(16);
    protected Map<Class<?>, Object> defaultValues = new IdentityHashMap(16);
    private static ValueUtils instance = null;

    protected ValueUtils() {
        this.typeMap.put(Boolean.class, ValueType.BOOLEAN);
        this.typeMap.put(Boolean.TYPE, ValueType.BOOLEAN);
        this.typeMap.put(Byte.class, ValueType.BYTE);
        this.typeMap.put(Byte.TYPE, ValueType.BYTE);
        this.typeMap.put(Short.class, ValueType.SHORT);
        this.typeMap.put(Short.TYPE, ValueType.SHORT);
        this.typeMap.put(Integer.class, ValueType.INTEGER);
        this.typeMap.put(Integer.TYPE, ValueType.INTEGER);
        this.typeMap.put(Long.class, ValueType.LONG);
        this.typeMap.put(Long.TYPE, ValueType.LONG);
        this.typeMap.put(BigInteger.class, ValueType.BIGINTEGER);
        this.typeMap.put(Float.class, ValueType.FLOAT);
        this.typeMap.put(Float.TYPE, ValueType.FLOAT);
        this.typeMap.put(Double.class, ValueType.DOUBLE);
        this.typeMap.put(Double.TYPE, ValueType.DOUBLE);
        this.typeMap.put(BigDecimal.class, ValueType.BIGDECIMAL);
        this.defaultValues.put(Boolean.TYPE, Boolean.FALSE);
        this.defaultValues.put(Boolean.class, Boolean.FALSE);
        this.defaultValues.put(Byte.TYPE, new Byte(0));
        this.defaultValues.put(Byte.class, new Byte(0));
        this.defaultValues.put(Character.TYPE, new Character('\u0000'));
        this.defaultValues.put(Character.class, new Character('\u0000'));
        this.defaultValues.put(Short.TYPE, new Short(0));
        this.defaultValues.put(Short.class, new Short(0));
        this.defaultValues.put(Integer.TYPE, new Integer(0));
        this.defaultValues.put(Integer.class, new Integer(0));
        this.defaultValues.put(Long.TYPE, new Long(0L));
        this.defaultValues.put(Long.class, new Long(0L));
        this.defaultValues.put(Float.TYPE, new Float(0.0f));
        this.defaultValues.put(Float.class, new Float(0.0f));
        this.defaultValues.put(Double.TYPE, new Double(0.0));
        this.defaultValues.put(Double.class, new Double(0.0));
    }

    public static synchronized ValueUtils getInstance() {
        if (instance == null) {
            instance = new ValueUtils();
        }
        return instance;
    }

    public ValueType getType(Object value) {
        Class<?> c;
        ValueType result = ValueType.ANY;
        if (value != null && (result = this.typeMap.get(c = value.getClass())) == null) {
            result = ValueType.ANY;
        }
        return result;
    }

    public ValueType getNumericType(ValueType t1, ValueType t2, boolean canBeNonNumeric) {
        if (t1 == t2) {
            return t1;
        }
        if (canBeNonNumeric && (t1 == ValueType.ANY || t2 == ValueType.ANY || t1 == ValueType.CHARACTER || t2 == ValueType.CHARACTER)) {
            return ValueType.ANY;
        }
        if (t1 == ValueType.ANY) {
            t1 = ValueType.DOUBLE;
        }
        if (t2 == ValueType.ANY) {
            t2 = ValueType.DOUBLE;
        }
        if (t1.compareTo(ValueType.FLOAT) >= 0) {
            if (t2.compareTo(ValueType.FLOAT) >= 0) {
                return ValueType.max(t1, t2);
            }
            if (t2.compareTo(ValueType.INTEGER) < 0) {
                return t1;
            }
            if (t2 == ValueType.BIGINTEGER) {
                return ValueType.BIGDECIMAL;
            }
            return ValueType.max(ValueType.DOUBLE, t2);
        }
        if (t2.compareTo(ValueType.FLOAT) >= 0) {
            if (t1.compareTo(ValueType.INTEGER) < 0) {
                return t2;
            }
            if (t1 == ValueType.BIGINTEGER) {
                return ValueType.BIGDECIMAL;
            }
            return ValueType.max(ValueType.DOUBLE, t2);
        }
        return ValueType.max(t1, t2);
    }

    public int compareWithConversion(Object v1, Object v2) {
        return this.compareWithConversion(v1, v2, null);
    }

    public int compareWithConversion(Object v1, Object v2, Number epsilon) {
        int result;
        if (v1 == v2) {
            result = 0;
        } else {
            ValueType t1 = this.getType(v1);
            ValueType t2 = this.getType(v2);
            ValueType type = this.getNumericType(t1, t2, true);
            switch (type) {
                case BIGINTEGER: {
                    result = this.bigIntValue(v1).compareTo(this.bigIntValue(v2));
                    break;
                }
                case BIGDECIMAL: {
                    result = this.bigDecValue(v1).compareTo(this.bigDecValue(v2));
                    break;
                }
                case ANY: {
                    if (t1 == ValueType.ANY && t2 == ValueType.ANY) {
                        if (v1 instanceof Comparable) {
                            result = ((Comparable)v1).compareTo(v2);
                            break;
                        }
                        throw new RuntimeException("invalid comparison: " + v1 + " <-> " + v2);
                    }
                }
                case FLOAT: 
                case DOUBLE: {
                    double dv1 = this.doubleValue(v1);
                    double dv2 = this.doubleValue(v2);
                    if (epsilon != null) {
                        double diff = Math.abs(dv1 - dv2);
                        result = diff < Math.abs(epsilon.doubleValue()) ? 0 : (dv1 < dv2 ? -1 : 1);
                        break;
                    }
                    result = dv1 == dv2 ? 0 : (dv1 < dv2 ? -1 : 1);
                    break;
                }
                default: {
                    long lv1 = this.longValue(v1);
                    long lv2 = this.longValue(v2);
                    result = lv1 == lv2 ? 0 : (lv1 < lv2 ? -1 : 1);
                }
            }
        }
        return result;
    }

    public String stringValue(Object value, boolean trim) {
        String result;
        if (value == null) {
            result = "";
        } else {
            result = value.toString();
            if (trim) {
                result = result.trim();
            }
        }
        return result;
    }

    public long longValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0L;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).longValue();
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1L : 0L;
        }
        return Long.parseLong(this.stringValue(value, true));
    }

    public double doubleValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0.0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).doubleValue();
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        String s = this.stringValue(value, true);
        return s.length() == 0 ? 0.0 : Double.parseDouble(s);
    }

    public BigDecimal bigDecValue(Object value) throws NumberFormatException {
        if (value == null) {
            return new BigDecimal(0);
        }
        Class<?> c = value.getClass();
        if (c == BigDecimal.class) {
            return (BigDecimal)value;
        }
        if (c == BigInteger.class) {
            return new BigDecimal((BigInteger)value);
        }
        if (c.getSuperclass() == Number.class) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (c == Character.class) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        if (c == Boolean.class) {
            return BigDecimal.valueOf((Boolean)value != false ? 1L : 0L);
        }
        return new BigDecimal(this.stringValue(value, true));
    }

    public BigInteger bigIntValue(Object value) throws NumberFormatException {
        if (value == null) {
            return new BigInteger(new byte[]{0});
        }
        Class<?> c = value.getClass();
        if (c == BigInteger.class) {
            return (BigInteger)value;
        }
        if (c == BigDecimal.class) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (c.getSuperclass() == Number.class) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (c == Character.class) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        if (c == Boolean.class) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        return new BigInteger(this.stringValue(value, true));
    }

    public Boolean booleanValue(Object value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean && Boolean.FALSE.equals(value) || value instanceof Number && ((Number)value).intValue() == 0 || value instanceof String && !Boolean.parseBoolean((String)value) || value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object add(Object v1, Object v2) {
        ValueType t1 = this.getType(v1);
        ValueType t2 = this.getType(v2);
        ValueType type = this.getNumericType(t1, t2, true);
        switch (type) {
            case BIGINTEGER: {
                return this.bigIntValue(v1).add(this.bigIntValue(v2));
            }
            case BIGDECIMAL: {
                return this.bigDecValue(v1).add(this.bigDecValue(v2));
            }
            case FLOAT: 
            case DOUBLE: {
                return this.createReal(type, this.doubleValue(v1) + this.doubleValue(v2));
            }
            case ANY: {
                return this.stringValue(v1, false) + this.stringValue(v2, false);
            }
        }
        return this.createInteger(type, this.longValue(v1) + this.longValue(v2));
    }

    public Object subtract(Object v1, Object v2) {
        ValueType type = this.getNumericType(this.getType(v1), this.getType(v2), false);
        switch (type) {
            case BIGINTEGER: {
                return this.bigIntValue(v1).subtract(this.bigIntValue(v2));
            }
            case BIGDECIMAL: {
                return this.bigDecValue(v1).subtract(this.bigDecValue(v2));
            }
            case FLOAT: 
            case DOUBLE: {
                return this.createReal(type, this.doubleValue(v1) - this.doubleValue(v2));
            }
        }
        return this.createInteger(type, this.longValue(v1) - this.longValue(v2));
    }

    public Object negate(Object v1) {
        ValueType type = this.getType(v1);
        switch (type) {
            case BIGINTEGER: {
                return this.bigIntValue(v1).negate();
            }
            case BIGDECIMAL: {
                return this.bigDecValue(v1).negate();
            }
            case FLOAT: 
            case DOUBLE: {
                return this.createReal(type, -this.doubleValue(v1));
            }
        }
        return this.createInteger(type, -this.longValue(v1));
    }

    public Object multiply(Object v1, Object v2) {
        ValueType type = this.getNumericType(this.getType(v1), this.getType(v2), false);
        switch (type) {
            case BIGINTEGER: {
                return this.bigIntValue(v1).multiply(this.bigIntValue(v2));
            }
            case BIGDECIMAL: {
                return this.bigDecValue(v1).multiply(this.bigDecValue(v2));
            }
            case FLOAT: 
            case DOUBLE: {
                return this.createReal(type, this.doubleValue(v1) * this.doubleValue(v2));
            }
        }
        return this.createInteger(type, this.longValue(v1) * this.longValue(v2));
    }

    public Object divide(Object v1, Object v2) {
        ValueType type = this.getNumericType(this.getType(v1), this.getType(v2), false);
        switch (type) {
            case BIGINTEGER: {
                return this.bigIntValue(v1).divide(this.bigIntValue(v2));
            }
            case BIGDECIMAL: {
                return this.bigDecValue(v1).divide(this.bigDecValue(v2), 6);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.createReal(type, this.doubleValue(v1) / this.doubleValue(v2));
            }
        }
        return this.createInteger(type, this.longValue(v1) / this.longValue(v2));
    }

    public Object remainder(Object v1, Object v2) {
        ValueType type = this.getNumericType(this.getType(v1), this.getType(v2), false);
        switch (type) {
            case BIGINTEGER: 
            case BIGDECIMAL: {
                return this.bigIntValue(v1).remainder(this.bigIntValue(v2));
            }
        }
        return this.createInteger(type, this.longValue(v1) % this.longValue(v2));
    }

    public Number createInteger(ValueType type, long value) {
        switch (type) {
            case BOOLEAN: 
            case CHARACTER: 
            case INTEGER: {
                return new Integer((int)value);
            }
            case FLOAT: {
                if ((long)((float)value) == value) {
                    return new Float(value);
                }
            }
            case DOUBLE: {
                if ((long)((double)value) == value) {
                    return new Double(value);
                }
            }
            case LONG: {
                return new Long(value);
            }
            case BYTE: {
                return new Byte((byte)value);
            }
            case SHORT: {
                return new Short((short)value);
            }
        }
        return BigInteger.valueOf(value);
    }

    public Number createReal(ValueType type, double value) {
        if (type == ValueType.FLOAT) {
            return new Float((float)value);
        }
        return new Double(value);
    }

    public Object convertValue(Class<?> toType, Object value, Object defaultValue) {
        Object result = value != null ? (toType == Integer.class || toType == Integer.TYPE ? new Integer((int)this.longValue(value)) : (toType == Double.class || toType == Double.TYPE ? new Double(this.doubleValue(value)) : (toType == Boolean.class || toType == Boolean.TYPE ? (this.booleanValue(value) != false ? Boolean.TRUE : Boolean.FALSE) : (toType == Byte.class || toType == Byte.TYPE ? new Byte((byte)this.longValue(value)) : (toType == Character.class || toType == Character.TYPE ? new Character((char)this.longValue(value)) : (toType == Short.class || toType == Short.TYPE ? new Short((short)this.longValue(value)) : (toType == Long.class || toType == Long.TYPE ? new Long(this.longValue(value)) : (toType == Float.class || toType == Float.TYPE ? new Float(this.doubleValue(value)) : (toType == BigInteger.class ? this.bigIntValue(value) : (toType == BigDecimal.class ? this.bigDecValue(value) : (toType == String.class ? this.stringValue(value, false) : value))))))))))) : defaultValue;
        return result;
    }
}

