/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.commons.util.internal.extensions;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import net.enilink.commons.util.internal.extensions.ContributorFactoryNonOSGI;
import net.enilink.commons.util.internal.extensions.DebugHelper;
import net.enilink.commons.util.internal.extensions.Utils;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;

public class RegistryStrategyNonOSGI
extends RegistryStrategy {
    private Object token;

    public RegistryStrategyNonOSGI(File[] storageDirs, boolean[] cacheReadOnly, Object token) {
        super(storageDirs, cacheReadOnly);
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(IExtensionRegistry registry, boolean loadedFromCache) {
        long startGlobalTime = System.currentTimeMillis();
        long startTime = 0L;
        int pluginXMLWithNoError = 0;
        int pluginXMLWithError = 0;
        int pluginXMLTotal = 0;
        try {
            ClassLoader cl;
            Enumeration<URL> pluginURLs;
            if (DebugHelper.DEBUG) {
                DebugHelper.log("BEGIN RegistryStrategyNonOSGI#onStart");
            }
            super.onStart(registry, loadedFromCache);
            if (!(registry instanceof ExtensionRegistry)) {
                if (DebugHelper.DEBUG) {
                    DebugHelper.log("Impossible to load <plugin.xml>. IExtensionRegistry must be an instance of <" + ExtensionRegistry.class.getName() + ">", 1);
                }
                return;
            }
            ExtensionRegistry extensionRegistry = (ExtensionRegistry)registry;
            if (DebugHelper.DEBUG) {
                startTime = System.currentTimeMillis();
                DebugHelper.log("Start searching <plugin.xml> URLs from the ClassLoader....", 1);
            }
            if ((pluginURLs = Utils.getPluginXMLs(cl = ((Object)((Object)this)).getClass().getClassLoader())) == null || !pluginURLs.hasMoreElements()) {
                if (DebugHelper.DEBUG) {
                    DebugHelper.log("No <plugin.xml> founded into the ClassLoader", 1);
                }
                return;
            }
            if (DebugHelper.DEBUG) {
                DebugHelper.log("End searching <plugin.xml> URLs from the ClassLoader with time=" + (System.currentTimeMillis() - startTime) + "(ms)", 1);
            }
            if (DebugHelper.DEBUG) {
                startTime = System.currentTimeMillis();
                DebugHelper.log("Start searching <META-INF/MANIFEST.MF> URLs from the ClassLoader....", 1);
            }
            Map<String, URL> manifests = Utils.getManifestsMap(cl);
            if (DebugHelper.DEBUG) {
                DebugHelper.log("End searching <META-INF/MANIFEST.MF> URLs from the ClassLoader with time=" + (System.currentTimeMillis() - startTime) + "(ms)", 1);
            }
            if (DebugHelper.DEBUG) {
                startTime = System.currentTimeMillis();
                DebugHelper.log("Start loading <plugin.xml> ....", 1);
            }
            while (pluginURLs.hasMoreElements()) {
                URL url = pluginURLs.nextElement();
                ++pluginXMLTotal;
                try {
                    if (this.loadPluginXML(url, extensionRegistry, manifests)) {
                        ++pluginXMLWithNoError;
                        continue;
                    }
                    ++pluginXMLWithError;
                }
                catch (RuntimeException e) {
                    ++pluginXMLWithError;
                    if (!DebugHelper.DEBUG) continue;
                    DebugHelper.logError(e);
                }
            }
            if (DebugHelper.DEBUG) {
                DebugHelper.log("End loading <plugin.xml> with time=" + (System.currentTimeMillis() - startTime) + "(ms)", 1);
            }
        }
        finally {
            if (DebugHelper.DEBUG) {
                DebugHelper.log("END RegistryStrategyNonOSGI#onStart: plugin.xml [OK]=<" + pluginXMLWithNoError + "/" + pluginXMLTotal + ">, plugin.xml [ERROR]=<" + pluginXMLWithError + "/" + pluginXMLTotal + ">, time=" + (System.currentTimeMillis() - startGlobalTime) + "(ms).");
            }
        }
    }

    private boolean loadPluginXML(URL pluginManifest, ExtensionRegistry extensionRegistry, Map<String, URL> manifests) {
        BufferedInputStream is;
        long startTime = System.currentTimeMillis();
        if (pluginManifest == null) {
            return false;
        }
        try {
            is = new BufferedInputStream(pluginManifest.openStream());
        }
        catch (IOException ex) {
            Object is2 = null;
            if (DebugHelper.DEBUG) {
                DebugHelper.logError("<plugin.xml> [ERROR] : (" + pluginManifest.getPath() + "): ", 1);
                DebugHelper.logError(ex);
            }
            return false;
        }
        String baseDir = Utils.getBaseDir(pluginManifest, "plugin.xml");
        URL manifestURL = manifests.get(baseDir);
        if (manifestURL == null) {
            if (DebugHelper.DEBUG) {
                DebugHelper.logError("<plugin.xml> [ERROR] : (" + pluginManifest.getPath() + "): ", 1);
                DebugHelper.logError("<META-INF/MANIFEST.MF> doesn't exist for the <plugin.xml>. <" + baseDir + "META-INF/MANIFEST.MF> not founded.", 2);
            }
            return false;
        }
        Optional<Object> symbolicName = Optional.empty();
        try {
            symbolicName = new BufferedReader(new InputStreamReader(manifestURL.openStream())).lines().filter(line -> line.startsWith("Bundle-SymbolicName")).map(line -> line.replaceAll("^[^:]+\\s*", "").replaceAll(";.*", "")).findFirst();
        }
        catch (Exception e) {
            if (DebugHelper.DEBUG) {
                DebugHelper.logError("<plugin.xml> [ERROR] : (" + pluginManifest.getPath() + "): ", 1);
                DebugHelper.logError("Error while parsing MANIFEST.MF=<" + manifestURL.getPath() + ">", 2);
                DebugHelper.logError(e);
            }
            return false;
        }
        if (!symbolicName.isPresent() || Utils.isEmpty((String)symbolicName.get())) {
            if (DebugHelper.DEBUG) {
                DebugHelper.logError("<plugin.xml> [ERROR] : (" + pluginManifest.getPath() + "): ", 1);
                DebugHelper.logError("Cannot found <Bundle-SymbolicName> from the MANIFEST.MF=<" + manifestURL.getPath() + ">", 2);
            }
            return false;
        }
        RegistryContributor contributor = ContributorFactoryNonOSGI.createContributor((String)symbolicName.get());
        if (extensionRegistry.hasContributor((IContributor)contributor)) {
            if (DebugHelper.DEBUG) {
                DebugHelper.logError("<plugin.xml> [ERROR] : (" + pluginManifest.getPath() + "): ", 1);
                DebugHelper.logError("Contributor with id=<" + contributor.getActualId() + "> already exits.", 2);
            }
            return false;
        }
        ResourceBundle translationBundle = null;
        long timestamp = 0L;
        if (!extensionRegistry.addContribution((InputStream)is, (IContributor)contributor, true, pluginManifest.getPath(), translationBundle, this.token, timestamp)) {
            if (DebugHelper.DEBUG) {
                DebugHelper.logError("<plugin.xml> [ERROR] : (" + pluginManifest.getPath() + "): ", 1);
                DebugHelper.logError("Parsing problems with plugin.xml", 2);
            }
            return false;
        }
        if (DebugHelper.DEBUG) {
            DebugHelper.log("<plugin.xml> [OK] loaded with time=" + (System.currentTimeMillis() - startTime) + "(ms) : (" + pluginManifest.getPath() + ")", 1);
        }
        return true;
    }
}

