/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClassDefiner
extends ClassLoader {
    private static final URL exists;
    private ConcurrentMap<String, byte[]> bytecodes = new ConcurrentHashMap<String, byte[]>();
    private File output;

    public ClassDefiner() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassDefiner(ClassLoader parent) {
        super(parent);
    }

    public ClassDefiner(File dir) {
        this(dir, Thread.currentThread().getContextClassLoader());
    }

    public ClassDefiner(File dir, ClassLoader parent) {
        super(parent);
        this.output = dir;
        dir.mkdirs();
    }

    @Override
    public URL getResource(String name) {
        if (this.output != null) {
            try {
                File file = new File(this.output, name);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (this.bytecodes != null && this.bytecodes.containsKey(name)) {
            return exists;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        File file;
        if (this.output != null && (file = new File(this.output, name)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (this.bytecodes != null && this.bytecodes.containsKey(name)) {
            byte[] b = (byte[])this.bytecodes.get(name);
            return new ByteArrayInputStream(b);
        }
        return this.getParent().getResourceAsStream(name);
    }

    public Class<?> defineClass(String name, byte[] bytecode) {
        String resource = name.replace('.', '/') + ".class";
        if (this.output != null) {
            this.saveResource(resource, bytecode);
        }
        if (this.bytecodes != null) {
            this.bytecodes.putIfAbsent(resource, bytecode);
        }
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResource(String fileName, byte[] bytecode) {
        try {
            File file = new File(this.output, fileName);
            file.getParentFile().mkdirs();
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(bytecode);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("object.proxies.") || name.startsWith("object.behaviours.")) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    throw new ClassNotFoundException(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }

    static {
        try {
            exists = new URL("http://java/" + ClassDefiner.class.getName().replace('.', '/') + "#exists");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

