/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.annotations.ParameterTypes;
import net.enilink.composition.asm.ExtendedClassNode;
import net.enilink.composition.asm.meta.ClassInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class AsmUtils {
    protected static Map<ClassLoader, Map<String, ClassInfo>> classInfos = new WeakHashMap<ClassLoader, Map<String, ClassInfo>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo getClassInfo(String className, ClassLoader classLoader) throws Exception {
        Map<String, ClassInfo> infoMap;
        Map<ClassLoader, Map<String, ClassInfo>> map = classInfos;
        synchronized (map) {
            infoMap = classInfos.get(classLoader);
            if (infoMap == null) {
                infoMap = new ConcurrentHashMap<String, ClassInfo>();
                classInfos.put(classLoader, infoMap);
            }
        }
        ClassInfo classInfo = infoMap.get(className);
        if (classInfo == null) {
            ClassReader reader = AsmUtils.createClassReader(className, classLoader);
            classInfo = new ClassInfo();
            reader.accept((ClassVisitor)classInfo, 4);
            infoMap.put(className, classInfo);
        }
        return classInfo;
    }

    public static ClassReader createClassReader(String className, ClassLoader classLoader) throws ClassNotFoundException {
        String classFilename = className.replace('.', '/') + ".class";
        InputStream inputStream = classLoader.getResourceAsStream(classFilename);
        try {
            return new ClassReader(inputStream);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Class not found: " + className, e);
        }
    }

    public static Class<?> defineExtendedClass(ClassDefiner definer, ExtendedClassNode classNode) {
        classNode.endClass();
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        AsmUtils.verifyClass(classNode, definer, classWriter.toByteArray());
        Class<?> newClass = definer.defineClass(classNode.name.replace('/', '.'), classWriter.toByteArray());
        return newClass;
    }

    protected static void verifyClass(ExtendedClassNode classNode, ClassDefiner definer, byte[] code) {
        PrintWriter writer = new PrintWriter(System.err);
        CheckClassAdapter.verify((ClassReader)new ClassReader(code), (ClassLoader)definer, (boolean)false, (PrintWriter)writer);
    }

    protected static void printClass(byte[] code) {
        ClassReader cr = new ClassReader(code);
        PrintWriter writer = new PrintWriter(System.err);
        cr.accept((ClassVisitor)new TraceClassVisitor(writer), 0);
    }

    public static Class<?> findClass(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T extends Annotation> T findAnnotation(Class<T> annotationClass, Method method) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Method superMethod = AsmUtils.findInterfaceOrSuperMethod(method, method.getDeclaringClass().getSuperclass(), method.getDeclaringClass().getInterfaces());
        if (superMethod != null && !method.equals(superMethod)) {
            annotation = AsmUtils.findAnnotation(annotationClass, superMethod);
        }
        return annotation;
    }

    public static Method findInterfaceOrSuperMethod(Method method, Class<?> baseClass, Class<?> ... interfaces) {
        Class<?>[] types;
        Class<?> type;
        String name = method.getName();
        Method m = AsmUtils.findInterfaceMethod(interfaces, name, type = method.getReturnType(), types = AsmUtils.getParameterTypes(method));
        if (m != null) {
            return m;
        }
        m = AsmUtils.findSuperMethod(baseClass, name, type, types);
        if (m != null) {
            return m;
        }
        return method;
    }

    public static Class<?>[] getParameterTypes(Method m) {
        if (m.isAnnotationPresent(ParameterTypes.class)) {
            return m.getAnnotation(ParameterTypes.class).value();
        }
        return m.getParameterTypes();
    }

    private static Method findSuperMethod(Class<?> base, String name, Class<?> type, Class<?>[] types) {
        Method m2;
        if (base == null) {
            return null;
        }
        try {
            m2 = base.getDeclaredMethod(name, types);
            if (m2.getReturnType().equals(type)) {
                return m2;
            }
        }
        catch (NoSuchMethodException m2) {
            // empty catch block
        }
        m2 = AsmUtils.findSuperMethod(base.getSuperclass(), name, type, types);
        if (m2 == null) {
            return null;
        }
        return m2;
    }

    private static Method findInterfaceMethod(Class<?>[] interfaces, String name, Class<?> type, Class<?>[] types) {
        for (Class<?> face : interfaces) {
            try {
                Method m = face.getDeclaredMethod(name, types);
                if (m.getReturnType().equals(type)) {
                    return m;
                }
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            Class<?>[] faces = face.getInterfaces();
            Method m = AsmUtils.findInterfaceMethod(faces, name, type, types);
            if (m == null) continue;
            return m;
        }
        return null;
    }
}

