/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.enilink.composition.BehaviourFactory;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.asm.AsmUtils;
import net.enilink.composition.asm.BehaviourClassNode;
import net.enilink.composition.asm.BehaviourClassProcessor;
import net.enilink.composition.asm.BehaviourMethodProcessor;
import net.enilink.composition.asm.DependsOn;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.UseWith;
import net.enilink.composition.exceptions.CompositionException;
import net.enilink.composition.helpers.IPartialOrder;
import net.enilink.composition.helpers.LinearExtension;
import org.objectweb.asm.Type;

public abstract class BehaviourFactoryBase
implements BehaviourFactory {
    @Inject
    protected ClassDefiner definer;
    protected List<BehaviourClassProcessor> classProcessors;
    private List<BehaviourMethodProcessor> methodProcessors;

    private <T> boolean dependsOn(T element, T other) {
        DependsOn dependsOn = element.getClass().getAnnotation(DependsOn.class);
        if (dependsOn != null) {
            for (Class<?> type : dependsOn.value()) {
                if (!type.isAssignableFrom(other.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    private <K, T> List<T> ensureList(Map<K, List<T>> map, K key) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        return list;
    }

    Class<?> extendBehaviourClass(String extendedClassName, Class<?> behaviourClass) throws Exception {
        MethodProcessorRunner runner;
        boolean createBehaviour;
        boolean bl = createBehaviour = !behaviourClass.isInterface();
        if (!createBehaviour) {
            for (BehaviourClassProcessor classProcessor : this.classProcessors) {
                if (!classProcessor.implementsClass(behaviourClass)) continue;
                createBehaviour = true;
            }
        }
        if (createBehaviour | (runner = new MethodProcessorRunner(behaviourClass)).implementsClass()) {
            BehaviourClassNode classNode = new BehaviourClassNode(Type.getObjectType((String)extendedClassName.replace('.', '/')), behaviourClass, AsmUtils.getClassInfo(behaviourClass.getName(), this.definer));
            for (BehaviourClassProcessor classProcessor : this.classProcessors) {
                classProcessor.process(classNode);
            }
            runner.process(classNode);
            return AsmUtils.defineExtendedClass(this.definer, classNode);
        }
        return null;
    }

    private <T> List<T> filterAndSort(Set<T> elements) {
        final HashSet<T> filteredElements = new HashSet<T>(elements);
        Iterator it = filteredElements.iterator();
        while (it.hasNext()) {
            UseWith useWith = it.next().getClass().getAnnotation(UseWith.class);
            if (useWith == null) continue;
            for (Class<? extends BehaviourFactory> type : useWith.value()) {
                if (type.isAssignableFrom(this.getClass())) continue;
                it.remove();
            }
        }
        final HashMap successors = new HashMap();
        for (Object element : filteredElements) {
            DependsOn dependsOn = element.getClass().getAnnotation(DependsOn.class);
            if (dependsOn == null) continue;
            for (Class<?> type : dependsOn.value()) {
                for (Object other : filteredElements) {
                    if (other == element || !type.isAssignableFrom(other.getClass()) || this.dependsOn(other, element)) continue;
                    this.ensureList(successors, other).add(element);
                }
            }
        }
        return LinearExtension.createLinearExtension(new IPartialOrder<T>(){

            @Override
            public Collection<T> getElements() {
                return filteredElements;
            }

            @Override
            public Collection<T> getSuccessors(T element) {
                return (Collection)successors.get(element);
            }
        });
    }

    protected abstract String getExtendedClassName(Class<?> var1);

    @Override
    public Collection<Class<?>> implement(Class<?> behaviourClass) throws Exception {
        String extendedClassName = this.getExtendedClassName(behaviourClass);
        Class<?> extendedClass = AsmUtils.findClass(extendedClassName, this.definer);
        if (extendedClass == null) {
            extendedClass = this.extendBehaviourClass(extendedClassName, behaviourClass);
        }
        return extendedClass != null ? Collections.singleton(extendedClass) : Collections.emptySet();
    }

    @Inject
    public void setClassProcessors(Set<BehaviourClassProcessor> classProcessors) {
        this.classProcessors = this.filterAndSort(classProcessors);
    }

    @Inject
    public void setMethodProcessors(Set<BehaviourMethodProcessor> methodProcessors) {
        this.methodProcessors = this.filterAndSort(methodProcessors);
    }

    class MethodProcessorRunner {
        Class<?> behaviourClass;
        Collection<Method> methods;

        public MethodProcessorRunner(Class<?> behaviourClass) {
            this.behaviourClass = behaviourClass;
            this.methods = this.getMethods();
        }

        private Collection<Method> getMethods() {
            ArrayList<Method> methods = new ArrayList<Method>();
            methods.addAll(Arrays.asList(this.behaviourClass.getMethods()));
            HashMap<Object, Method> map = new HashMap<Object, Method>();
            Map<Object, Method> pms = this.getProtectedMethods(this.behaviourClass, map);
            methods.addAll(pms.values());
            return methods;
        }

        private Map<Object, Method> getProtectedMethods(Class<?> c, Map<Object, Method> methods) {
            if (c == null || c.isInterface()) {
                return methods;
            }
            for (Method m : c.getDeclaredMethods()) {
                List<Object> key;
                if (!Modifier.isProtected(m.getModifiers()) || methods.containsKey(key = Arrays.asList(m.getName(), Arrays.asList(m.getParameterTypes())))) continue;
                methods.put(key, m);
            }
            return this.getProtectedMethods(c.getSuperclass(), methods);
        }

        public boolean implementsClass() {
            for (Method method : this.methods) {
                for (BehaviourMethodProcessor methodProcessor : BehaviourFactoryBase.this.methodProcessors) {
                    if (!methodProcessor.implementsMethod(this.behaviourClass, method)) continue;
                    return true;
                }
            }
            return false;
        }

        public void process(BehaviourClassNode classNode) throws Exception {
            HashSet<BehaviourMethodProcessor> initialized = new HashSet<BehaviourMethodProcessor>();
            for (Method method : this.methods) {
                ExtendedMethod behaviourMethod = classNode.getExtendedMethod(method);
                for (BehaviourMethodProcessor methodProcessor : BehaviourFactoryBase.this.methodProcessors) {
                    boolean implementsMethod = false;
                    if (behaviourMethod == null && methodProcessor.implementsMethod(classNode.getParentClass(), method)) {
                        behaviourMethod = classNode.addExtendedMethod(method, BehaviourFactoryBase.this.definer);
                        implementsMethod = true;
                    }
                    if (behaviourMethod != null && methodProcessor.appliesTo(classNode, behaviourMethod)) {
                        if (initialized.add(methodProcessor)) {
                            methodProcessor.initialize(classNode);
                        }
                        methodProcessor.process(classNode, behaviourMethod);
                        continue;
                    }
                    if (!implementsMethod) continue;
                    throw new CompositionException("Processor " + methodProcessor.getClass() + " pretended to implement method " + behaviourMethod.getOverriddenMethod() + " of class " + classNode.getType().getClassName() + " but was not applied.");
                }
            }
        }
    }
}

