/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.enilink.composition.asm.ExtendedClassNode;
import net.enilink.composition.asm.util.MethodNodeGenerator;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.FieldNode;

public class CompositeClassNode
extends ExtendedClassNode {
    protected Set<Class<?>> interfaceClassesSet = new LinkedHashSet();
    protected Class<?>[] interfaceClasses;
    private Map<List<?>, FieldNode> methodFields = new HashMap();
    private int varCount;

    public CompositeClassNode(Type type, Class<?> parentClass) {
        super(type, parentClass, null);
    }

    public void addInterfaceClass(Class<?> face) {
        if (this.interfaceClassesSet.add(face)) {
            this.interfaces.add(Type.getInternalName(face));
            this.interfaceClasses = null;
        }
    }

    public Class<?>[] getInterfacesClasses() {
        if (this.interfaceClasses == null) {
            this.interfaceClasses = this.interfaceClassesSet.toArray(new Class[this.interfaceClassesSet.size()]);
        }
        return this.interfaceClasses;
    }

    public FieldNode addStaticMethodField(Type declaringClass, String name, Type returnType, Type[] paramTypes) {
        List<Object> key = Arrays.asList(declaringClass, name, Arrays.asList(paramTypes));
        FieldNode field = this.methodFields.get(key);
        if (field == null) {
            field = new FieldNode(10, "_$method" + ++this.varCount, Type.getDescriptor(java.lang.reflect.Method.class), null, null);
            this.fields.add(field);
            this.methodFields.put(key, field);
            MethodNodeGenerator gen = this.getClassInitGen();
            gen.push(declaringClass);
            gen.push(name);
            gen.loadArray(paramTypes);
            gen.invokeVirtual(Type.getType(Class.class), new Method("getDeclaredMethod", Type.getType(java.lang.reflect.Method.class), new Type[]{Type.getType(String.class), Type.getType(Class[].class)}));
            gen.putStatic(this.getType(), field.name, Type.getType((String)field.desc));
        }
        return field;
    }
}

