/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm.processors;

import java.lang.reflect.Modifier;
import net.enilink.composition.asm.BehaviourClassNode;
import net.enilink.composition.asm.BehaviourMethodProcessor;
import net.enilink.composition.asm.DependsOn;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.Types;
import net.enilink.composition.asm.util.MethodNodeGenerator;
import net.enilink.composition.traits.Behaviour;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@DependsOn(value={BehaviourMethodProcessor.class})
public class MethodDelegationGenerator
implements BehaviourMethodProcessor,
Opcodes,
Types {
    @Override
    public boolean appliesTo(BehaviourClassNode classNode, ExtendedMethod method) {
        return method.instructions.size() == 0;
    }

    @Override
    public boolean implementsMethod(Class<?> targetClass, java.lang.reflect.Method method) {
        if (targetClass.isInterface() || Modifier.isFinal(method.getModifiers()) || !Modifier.isAbstract(method.getModifiers()) || Behaviour.class.equals(method.getDeclaringClass())) {
            return false;
        }
        return method.getDeclaringClass().isInterface();
    }

    @Override
    public void initialize(BehaviourClassNode classNode) throws Exception {
    }

    @Override
    public void process(BehaviourClassNode classNode, ExtendedMethod method) throws Exception {
        method.access &= 0xFFFFFBFF;
        method.access |= 0x80;
        MethodNodeGenerator gen = new MethodNodeGenerator(method);
        gen.loadThis();
        gen.invokeInterface(BEHAVIOUR_TYPE, new Method("getBehaviourDelegate", OBJECT_TYPE, new Type[0]));
        Type faceType = Type.getType(method.getOverriddenMethod().getDeclaringClass());
        gen.checkCast(faceType);
        gen.loadArgs();
        gen.invokeInterface(faceType, new Method(method.name, method.desc));
        gen.returnValue();
        gen.endMethod();
    }
}

