/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm.util;

import java.util.Stack;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class InsnListGenerator
extends GeneratorAdapter {
    public InsnList instructions;
    protected MethodNode mn;
    protected Stack<InsnList> stack;

    public InsnListGenerator(MethodNode mn) {
        super(327680, (MethodVisitor)mn, mn.access, mn.name, mn.desc);
        this.mn = mn;
        this.instructions = mn.instructions;
    }

    public InsnListGenerator(int access, String name, String desc, String signature, String[] exceptions) {
        this(new MethodNode(access, name, desc, signature, exceptions));
    }

    public InsnListGenerator(int access, String name, String desc) {
        this(access, name, desc, null, null);
    }

    public InsnList pushInsns() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.stack.push(this.instructions);
        this.instructions = new InsnList();
        return this.instructions;
    }

    public InsnList popInsns() {
        if (this.stack == null || this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot restore instructions from empty stack");
        }
        this.instructions = this.stack.pop();
        return this.instructions;
    }

    public InsnList peekInsns() {
        if (this.stack == null || this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot restore instructions from empty stack");
        }
        return this.stack.peek();
    }

    public void invokeSpecial(Type type, Method method) {
        super.invokeConstructor(type, method);
    }

    public void loadArray(Type[] types) {
        Type classType = Type.getType(Class.class);
        this.push(types.length);
        this.newArray(classType);
        for (int i = 0; i < types.length; ++i) {
            this.dup();
            this.push(i);
            this.push(types[i]);
            this.arrayStore(classType);
        }
    }
}

