/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.asm.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import net.enilink.composition.asm.Types;
import net.enilink.composition.asm.util.InsnListGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;

public class MethodNodeGenerator
extends InsnListGenerator {
    public MethodNode mn;

    public MethodNodeGenerator(int access, String name, String desc) {
        this(access, name, desc, null, null);
    }

    public MethodNodeGenerator(int access, String name, String desc, String signature, String[] exceptions) {
        this(new MethodNode(access, name, desc, signature, exceptions));
    }

    public MethodNodeGenerator(MethodNode mn) {
        super(mn);
        this.mn = mn;
    }

    public void accept(ClassVisitor cv) {
        this.mn.accept(cv);
    }

    public void accept(MethodVisitor mv) {
        this.mn.accept(mv);
    }

    public void appendToStringBuilder() {
        Type type = Type.getType(StringBuilder.class);
        this.invokeVirtual(type, new Method("append", type, new Type[]{Types.STRING_TYPE}));
    }

    public void invokeToString() {
        this.invokeVirtual(Types.OBJECT_TYPE, new Method("toString", Types.STRING_TYPE, new Type[0]));
    }

    public InsnListGenerator createSubGenerator() {
        return new InsnListGenerator(new MethodNode(this.mn.access, this.mn.name, this.mn.desc, this.mn.signature, this.mn.exceptions.toArray(new String[this.mn.exceptions.size()])));
    }

    public void invoke(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        Type declaringType = Type.getType(declaringClass);
        Method methodDesc = Method.getMethod(constructor);
        this.invokeConstructor(declaringType, methodDesc);
    }

    public void invoke(java.lang.reflect.Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Type declaringType = Type.getType(declaringClass);
        Method methodDesc = Method.getMethod((java.lang.reflect.Method)method);
        if (declaringClass.isInterface()) {
            this.invokeInterface(declaringType, methodDesc);
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.invokeStatic(declaringType, methodDesc);
        } else {
            this.invokeVirtual(declaringType, methodDesc);
        }
    }

    public void newStringBuilder() {
        Type type = Type.getType(StringBuilder.class);
        this.newInstance(type);
        this.dup();
        this.invokeConstructor(type, new Method("<init>", Type.VOID_TYPE, new Type[0]));
    }
}

