/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.helpers;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.annotations.ParameterTypes;
import net.enilink.composition.annotations.Precedes;
import net.enilink.composition.asm.AsmUtils;
import net.enilink.composition.asm.CompositeClassNode;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.Types;
import net.enilink.composition.asm.processors.CompositeConstructorGenerator;
import net.enilink.composition.asm.util.ExtendedMethodGenerator;
import net.enilink.composition.asm.util.MethodNodeGenerator;
import net.enilink.composition.exceptions.CompositionException;
import net.enilink.composition.helpers.Methods;
import net.enilink.composition.traits.Behaviour;
import org.aopalliance.intercept.MethodInvocation;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassComposer<T>
implements Types,
Opcodes {
    private String RDFS_SUBCLASSOF = "http://www.w3.org/2000/01/rdf-schema#subClassOf";
    private ClassDefiner definer;
    private String className;
    private Class<?> baseClass = Object.class;
    private Set<Class<?>> interfaces;
    private Set<Class<?>> javaClasses;
    private Collection<java.lang.reflect.Method> methods;
    private Map<String, java.lang.reflect.Method> namedMethods;
    private List<Class<?>> behaviours;
    private Map<java.lang.reflect.Method, String> superMethods = new HashMap<java.lang.reflect.Method, String>();
    private CompositeClassNode compositeClass;

    public ClassComposer(String className, int size) {
        this.className = className;
        this.interfaces = new LinkedHashSet(size);
        this.javaClasses = new LinkedHashSet(size);
    }

    @Inject
    public void setClassDefiner(ClassDefiner definer) {
        this.definer = definer;
    }

    public void setBaseClass(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    public Set<Class<?>> getInterfaces() {
        return this.interfaces;
    }

    public void addInterface(Class<?> iface) {
        this.interfaces.add(iface);
    }

    public void addAllBehaviours(Collection<Class<?>> javaClasses) {
        this.javaClasses.addAll(javaClasses);
    }

    public Class<?> compose() throws Exception {
        this.compositeClass = new CompositeClassNode(Type.getObjectType((String)this.className.replace('.', '/')), this.baseClass);
        for (Class<?> clazz : this.javaClasses) {
            this.addInterfaces(clazz);
        }
        for (Class<?> face : this.interfaces) {
            this.compositeClass.addInterfaceClass(face);
        }
        new CompositeConstructorGenerator().process(this.compositeClass);
        this.compositeClass.addInjectorField();
        this.behaviours = new ArrayList();
        for (Class<?> clazz : this.javaClasses) {
            if (!this.addBehaviour(clazz)) continue;
            this.behaviours.add(clazz);
        }
        if (this.baseClass != null && !Object.class.equals(this.baseClass)) {
            this.javaClasses.add(this.baseClass);
        }
        this.methods = this.getMethods();
        this.namedMethods = new HashMap<String, java.lang.reflect.Method>(this.methods.size());
        for (java.lang.reflect.Method method : this.methods) {
            String uri;
            if (!method.isAnnotationPresent(Iri.class) || this.namedMethods.containsKey(uri = method.getAnnotation(Iri.class).value()) && this.isBridge(method, this.methods)) continue;
            this.namedMethods.put(uri, method);
        }
        for (java.lang.reflect.Method method : this.methods) {
            if (method.getName().startsWith("_$")) continue;
            boolean bridge = this.isBridge(method, this.methods);
            this.implementMethod(method, method.getName(), bridge);
        }
        return AsmUtils.defineExtendedClass(this.definer, this.compositeClass);
    }

    private void addInterfaces(Class<?> clazz) {
        Class<?> superclass;
        if (this.interfaces.contains(clazz)) {
            return;
        }
        if (clazz.isInterface() && !this.isSpecial(clazz)) {
            this.interfaces.add(clazz);
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            this.addInterfaces(superclass);
        }
        for (Class<?> face : clazz.getInterfaces()) {
            this.addInterfaces(face);
        }
    }

    private Collection<java.lang.reflect.Method> getMethods() {
        ArrayList<Object> list;
        Class<?>[] ptypes;
        HashMap map = new HashMap();
        for (Class<?> face : this.interfaces) {
            for (java.lang.reflect.Method m : face.getMethods()) {
                if (this.isSpecial(m)) continue;
                ptypes = this.getParameterTypes(m);
                list = new ArrayList<Object>(ptypes.length + 2);
                list.add(m.getName());
                list.add(m.getReturnType());
                list.addAll(Arrays.asList(ptypes));
                if (map.containsKey(list)) {
                    if (this.getRank(m) <= this.getRank((java.lang.reflect.Method)map.get(list))) continue;
                    map.put(list, m);
                    continue;
                }
                map.put(list, m);
            }
        }
        for (Class<?> face : this.javaClasses) {
            for (java.lang.reflect.Method m : face.getMethods()) {
                if (this.isSpecial(m)) continue;
                ptypes = this.getParameterTypes(m);
                list = new ArrayList(ptypes.length + 2);
                list.add(m.getName());
                list.add(m.getReturnType());
                list.addAll(Arrays.asList(ptypes));
                if (map.containsKey(list)) {
                    if (this.getRank(m) <= this.getRank((java.lang.reflect.Method)map.get(list))) continue;
                    map.put(list, m);
                    continue;
                }
                map.put(list, m);
            }
        }
        return map.values();
    }

    private int getRank(java.lang.reflect.Method m) {
        int rank = m.getAnnotations().length;
        if (m.isAnnotationPresent(ParameterTypes.class)) {
            return rank - 1;
        }
        return rank;
    }

    private boolean isSpecial(Class<?> iface) {
        return Behaviour.class.isAssignableFrom(iface);
    }

    private boolean isSpecial(java.lang.reflect.Method m) {
        if (Modifier.isStatic(m.getModifiers()) || Modifier.isTransient(m.getModifiers())) {
            return true;
        }
        return Object.class.equals(m.getDeclaringClass());
    }

    private Class<?>[] getParameterTypes(java.lang.reflect.Method m) {
        if (m.isAnnotationPresent(ParameterTypes.class)) {
            return m.getAnnotation(ParameterTypes.class).value();
        }
        return m.getParameterTypes();
    }

    private boolean isBridge(java.lang.reflect.Method method, Collection<java.lang.reflect.Method> methods) {
        for (java.lang.reflect.Method m : methods) {
            if (!m.getName().equals(method.getName()) || !Arrays.equals(this.getParameterTypes(m), this.getParameterTypes(method)) || m.getReturnType().equals(method.getReturnType()) || !m.getReturnType().isAssignableFrom(method.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private Type[] toTypes(Class<?>[] classes) {
        Type[] types = new Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = Type.getType(classes[i]);
        }
        return types;
    }

    private boolean implementMethod(java.lang.reflect.Method method, String name, boolean bridge) throws Exception {
        List<Class<?>> chain = this.chain(method);
        List<Object[]> implementations = this.getImplementations(chain, method);
        if (implementations.isEmpty()) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        boolean returnsVoid = returnType.equals(Void.TYPE);
        boolean dynamicChained = false;
        for (Object[] ar : implementations) {
            java.lang.reflect.Method m = (java.lang.reflect.Method)ar[1];
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (parameterTypes.length != 1 || !MethodInvocation.class.equals(parameterTypes[0])) continue;
            dynamicChained = true;
            break;
        }
        java.lang.reflect.Method face = AsmUtils.findInterfaceOrSuperMethod(method, method.getDeclaringClass(), this.compositeClass.getInterfacesClasses());
        ExtendedMethod newMethod = this.compositeClass.addExtendedMethod(face, this.definer);
        newMethod.instructions.clear();
        if (bridge) {
            newMethod.access |= 0x40;
        }
        MethodNodeGenerator gen = new MethodNodeGenerator(newMethod);
        Label endLabel = gen.newLabel();
        boolean chainStarted = false;
        for (Object[] ar : implementations) {
            Object target = ar[0];
            java.lang.reflect.Method m = (java.lang.reflect.Method)ar[1];
            if (dynamicChained) {
                if (!chainStarted) {
                    chainStarted = true;
                    gen.newInstance(METHODINVOCATIONCHAIN_TYPE);
                    gen.dup();
                    gen.loadThis();
                    this.loadMethodObject(Type.getType(method.getDeclaringClass()), method.getName(), Type.getType(method.getReturnType()), this.toTypes(method.getParameterTypes()), gen);
                    gen.loadArgArray();
                    gen.invokeConstructor(METHODINVOCATIONCHAIN_TYPE, new Method("<init>", Type.VOID_TYPE, new Type[]{OBJECT_TYPE, Type.getType(java.lang.reflect.Method.class), Type.getType(Object[].class)}));
                }
                if ("super".equals(target)) {
                    String dname = this.createSuperCall(m);
                    this.appendInvocation("this", this.compositeClass.getType(), dname, Type.getType(m.getReturnType()), this.toTypes(m.getParameterTypes()), gen);
                    continue;
                }
                this.appendInvocation(target, Type.getType(m.getDeclaringClass()), m.getName(), Type.getType(m.getReturnType()), this.toTypes(m.getParameterTypes()), gen);
                continue;
            }
            this.callMethod(target, m, gen);
            if (m.getReturnType().equals(Void.TYPE)) continue;
            if (returnsVoid) {
                gen.pop();
                continue;
            }
            gen.box(Type.getType(m.getReturnType()));
            gen.dup();
            gen.push(Type.getType(m.getReturnType()));
            gen.invoke(Methods.METHODINVOCATIONCHAIN_ISNIL);
            Label isNilLabel = gen.newLabel();
            gen.ifZCmp(154, isNilLabel);
            gen.push(Type.getType(m.getReturnType()));
            gen.push(Type.getType(returnType));
            gen.invoke(Methods.METHODINVOCATIONCHAIN_CAST);
            gen.unbox(Type.getType(returnType));
            gen.goTo(endLabel);
            gen.mark(isNilLabel);
            gen.pop();
        }
        if (!dynamicChained && !returnsVoid) {
            gen.push(Type.getType(returnType));
            gen.invoke(Methods.METHODINVOCATIONCHAIN_NIL);
            gen.unbox(Type.getType(returnType));
        }
        if (chainStarted) {
            gen.invokeVirtual(METHODINVOCATIONCHAIN_TYPE, Method.getMethod((String)"Object proceed()"));
            if (returnsVoid) {
                gen.pop();
            } else {
                gen.unbox(Type.getType(returnType));
            }
        }
        gen.mark(endLabel);
        gen.returnValue();
        gen.endMethod();
        return true;
    }

    private String createSuperCall(java.lang.reflect.Method m) {
        if (this.superMethods.containsKey(m)) {
            return this.superMethods.get(m);
        }
        String name = "_$super" + this.superMethods.size() + "_" + m.getName();
        MethodNode mn = new MethodNode(2, name, Type.getMethodDescriptor((java.lang.reflect.Method)m), null, null);
        this.compositeClass.methods.add(mn);
        MethodNodeGenerator gen = new MethodNodeGenerator(mn);
        gen.loadThis();
        gen.loadArgs();
        gen.invokeSpecial(this.compositeClass.getParentType(), Method.getMethod((java.lang.reflect.Method)m));
        gen.returnValue();
        gen.endMethod();
        this.superMethods.put(m, name);
        return name;
    }

    private List<Class<?>> chain(java.lang.reflect.Method method) throws Exception {
        Class behaviour;
        if (this.behaviours == null) {
            return null;
        }
        int size = this.behaviours.size();
        ArrayList all = new ArrayList(size);
        for (Class<?> behaviour2 : this.behaviours) {
            if (!this.isMethodPresent(behaviour2, method)) continue;
            all.add(behaviour2);
        }
        ArrayList rest = new ArrayList(all.size());
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            behaviour = (Class)iter.next();
            if (this.isOverridesPresent(behaviour)) continue;
            rest.add(behaviour);
            iter.remove();
        }
        rest.addAll(all);
        all = rest;
        rest = new ArrayList(all.size());
        iter = all.iterator();
        while (iter.hasNext()) {
            behaviour = (Class)iter.next();
            if (!this.getMethod(behaviour, method).isAnnotationPresent(ParameterTypes.class)) continue;
            rest.add(behaviour);
            iter.remove();
        }
        rest.addAll(all);
        ArrayList list = new ArrayList(rest.size());
        while (!rest.isEmpty()) {
            int before = rest.size();
            iter = rest.iterator();
            block4: while (iter.hasNext()) {
                Class b1 = (Class)iter.next();
                for (Class clazz : rest) {
                    if (clazz == b1 || !this.overrides(clazz, b1)) continue;
                    continue block4;
                }
                list.add(b1);
                iter.remove();
            }
            if (before > rest.size()) continue;
            throw new CompositionException("Invalid method chain: " + ((Object)rest).toString());
        }
        return list;
    }

    private List<Object[]> getImplementations(List<Class<?>> behaviours, java.lang.reflect.Method method) throws Exception {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Class<?> type = method.getReturnType();
        Class<?> superclass = this.compositeClass.getParentClass();
        Class<?>[] types = this.getParameterTypes(method);
        if (behaviours != null) {
            for (Class<?> behaviour : behaviours) {
                list.add(new Object[]{behaviour, this.getMethod(behaviour, method)});
            }
        }
        if (!superclass.equals(Object.class)) {
            try {
                java.lang.reflect.Method m = superclass.getMethod(method.getName(), types);
                Class<?> returnType = m.getReturnType();
                if (!Modifier.isAbstract(m.getModifiers()) && returnType.equals(type)) {
                    list.add(new Object[]{"super", m});
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (java.lang.reflect.Method m : this.getSuperMethods(method)) {
            if (m.equals(method)) continue;
            list.addAll(this.getImplementations(this.chain(m), m));
        }
        return list;
    }

    private List<java.lang.reflect.Method> getSuperMethods(java.lang.reflect.Method method) {
        ArrayList<java.lang.reflect.Method> list = new ArrayList<java.lang.reflect.Method>();
        for (String uri : this.getAnnotationValueByIri(method, this.RDFS_SUBCLASSOF)) {
            java.lang.reflect.Method m = this.namedMethods.get(uri);
            if (m == null || this.isSpecial(m)) continue;
            list.add(m);
        }
        return list;
    }

    private String[] getAnnotationValueByIri(java.lang.reflect.Method method, String annotationID) {
        for (Annotation ann : method.getAnnotations()) {
            for (java.lang.reflect.Method am : ann.annotationType().getDeclaredMethods()) {
                Object value;
                Iri Iri2;
                if (am.getParameterTypes().length > 0 || (Iri2 = am.getAnnotation(Iri.class)) == null || !annotationID.equals(Iri2.value()) || !((value = this.invoke(am, ann)) instanceof String[])) continue;
                return (String[])value;
            }
        }
        return new String[0];
    }

    private Object invoke(java.lang.reflect.Method method, Annotation ann) {
        try {
            return method.invoke((Object)ann, new Object[0]);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            throw new CompositionException(e.getCause());
        }
    }

    private void appendInvocation(Object target, Type declaringClass, String name, Type returnType, Type[] paramTypes, MethodNodeGenerator gen) {
        gen.dup();
        gen.loadThis();
        if (!target.equals("this")) {
            this.loadBehaviour((Class)target, gen);
        }
        this.loadMethodObject(declaringClass, name, returnType, paramTypes, gen);
        gen.invokeVirtual(METHODINVOCATIONCHAIN_TYPE, new Method("appendInvocation", METHODINVOCATIONCHAIN_TYPE, new Type[]{OBJECT_TYPE, Type.getType(java.lang.reflect.Method.class)}));
    }

    private void loadBehaviour(Class<?> behaviourClass, MethodNodeGenerator gen) {
        gen.invokeVirtual(this.compositeClass.getType(), new Method(this.getGetterName(behaviourClass), Type.getType(behaviourClass), new Type[0]));
    }

    private void loadMethodObject(Type declaringClass, String name, Type returnType, Type[] paramTypes, MethodNodeGenerator gen) {
        FieldNode methodField = this.compositeClass.addStaticMethodField(declaringClass, name, returnType, paramTypes);
        gen.getStatic(this.compositeClass.getType(), methodField.name, Type.getType((String)methodField.desc));
    }

    private void callMethod(Object target, java.lang.reflect.Method method, MethodNodeGenerator gen) {
        gen.loadThis();
        if ("super".equals(target)) {
            gen.loadArgs();
            gen.invokeSpecial(Type.getType(this.baseClass), Method.getMethod((java.lang.reflect.Method)method));
        } else {
            if (!"this".equals(target)) {
                this.loadBehaviour((Class)target, gen);
            }
            gen.loadArgs();
            gen.invokeVirtual(Type.getType(method.getDeclaringClass()), Method.getMethod((java.lang.reflect.Method)method));
        }
    }

    private boolean isMethodPresent(Class<?> javaClass, java.lang.reflect.Method method) throws Exception {
        return this.getMethod(javaClass, method) != null;
    }

    private java.lang.reflect.Method getMethod(Class<?> javaClass, java.lang.reflect.Method method) throws Exception {
        Object[] types = method.getParameterTypes();
        try {
            java.lang.reflect.Method m = javaClass.getMethod(method.getName(), (Class<?>[])types);
            if (!(Modifier.isAbstract(m.getModifiers()) || Modifier.isTransient(m.getModifiers()) || this.isObjectMethod(m))) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (java.lang.reflect.Method m : javaClass.getMethods()) {
            ParameterTypes ann;
            if (!m.getName().equals(method.getName()) || (ann = m.getAnnotation(ParameterTypes.class)) == null || !Arrays.equals(ann.value(), types)) continue;
            return m;
        }
        return null;
    }

    private boolean isOverridesPresent(Class<?> javaClass) {
        return javaClass.getAnnotation(Precedes.class) != null;
    }

    private boolean overrides(Class<?> javaClass, Class<?> b1) throws Exception {
        Precedes precedes = javaClass.getAnnotation(Precedes.class);
        if (precedes != null) {
            for (Class<?> c : precedes.value()) {
                if (!c.isAssignableFrom(b1)) continue;
                return true;
            }
        }
        return false;
    }

    private String getGetterName(Class<?> javaClass) {
        return "_$get" + javaClass.getSimpleName() + Integer.toHexString(javaClass.getName().hashCode());
    }

    private boolean addBehaviour(Class<?> javaClass) throws Exception {
        Type behaviourType = Type.getType(javaClass);
        try {
            Constructor<?> constructor;
            String getterName = this.getGetterName(javaClass);
            String fieldName = "_$" + getterName.substring(5);
            ExtendedMethod mn = new ExtendedMethod(this.compositeClass, 2, getterName, Type.getMethodDescriptor((Type)behaviourType, (Type[])new Type[0]), null, null);
            ExtendedMethodGenerator gen = new ExtendedMethodGenerator(mn);
            Label exists = gen.newLabel();
            gen.loadThis();
            gen.getField(this.compositeClass.getType(), fieldName, behaviourType);
            gen.dup();
            gen.ifNonNull(exists);
            gen.pop();
            gen.newInstance(behaviourType);
            gen.dup();
            try {
                constructor = javaClass.getConstructor(Object.class);
                gen.loadThis();
            }
            catch (NoSuchMethodException e) {
                constructor = javaClass.getConstructor(new Class[0]);
            }
            gen.invokeConstructor(behaviourType, Method.getMethod(constructor));
            gen.injectMembers();
            gen.dup();
            gen.loadThis();
            gen.swap();
            gen.putField(this.compositeClass.getType(), fieldName, behaviourType);
            gen.mark(exists);
            gen.returnValue();
            gen.endMethod();
            this.compositeClass.methods.add(mn);
            this.compositeClass.fields.add(new FieldNode(2, fieldName, behaviourType.getDescriptor(), null, null));
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean isObjectMethod(java.lang.reflect.Method m) {
        return m.getDeclaringClass().getName().equals(Object.class.getName());
    }
}

