/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.exceptions.BehaviourException;
import org.aopalliance.intercept.MethodInvocation;

public class MethodInvocationChain
implements MethodInvocation {
    private final Object[] arguments;
    private int count;
    private final List<Method> invokeMethod = new ArrayList<Method>();
    private final List<Object> invokeTarget = new ArrayList<Object>();
    private final Method method;
    private final Object target;

    public MethodInvocationChain(Object target, Method method, Object[] arguments) {
        this.target = target;
        this.method = method;
        this.arguments = arguments;
    }

    public synchronized MethodInvocationChain appendInvocation(Object target, Method method) {
        this.invokeTarget.add(target);
        this.invokeMethod.add(method);
        return this;
    }

    public static Object cast(Object result, Class<?> resultType, Class<?> responseType) {
        if (MethodInvocationChain.isNil(result, resultType)) {
            return MethodInvocationChain.nil(responseType);
        }
        if (resultType.equals(responseType) || Object.class.equals(resultType)) {
            return result;
        }
        if (responseType.equals(Set.class)) {
            return Collections.singleton(result);
        }
        if (resultType.equals(Set.class)) {
            Set set = (Set)result;
            if (set.isEmpty()) {
                return MethodInvocationChain.nil(responseType);
            }
            return set.iterator().next();
        }
        return result;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    private Object[] getArguments(Method method) {
        Object[] parameters = this.getArguments();
        Annotation[][] anns = method.getParameterAnnotations();
        Object[] result = new Object[anns.length];
        for (int i = 0; i < anns.length; ++i) {
            if (i < parameters.length) {
                result[i] = parameters[i];
            }
            for (int j = 0; j < anns[i].length; ++j) {
                if (!anns[i][j].annotationType().equals(Iri.class)) continue;
                String uri = ((Iri)anns[i][j]).value();
                result[i] = parameters[this.getParameterIndex(uri)];
            }
        }
        return result;
    }

    public Method getMethod() {
        return this.method;
    }

    private int getParameterIndex(String uri) {
        Annotation[][] anns = this.method.getParameterAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            for (int j = 0; j < anns[i].length; ++j) {
                if (!anns[i][j].annotationType().equals(Iri.class) || !((Iri)anns[i][j]).value().equals(uri)) continue;
                return i;
            }
        }
        throw new UnsupportedOperationException("Parameter not found: " + uri);
    }

    public AccessibleObject getStaticPart() {
        return this.method;
    }

    public Object getThis() {
        return this.target;
    }

    public static boolean isNil(Object result, Class<?> type) {
        if (result == null) {
            return true;
        }
        if (!type.isPrimitive()) {
            return false;
        }
        return result.equals(MethodInvocationChain.nil(type));
    }

    public static Object nil(Class<?> type) {
        if (Set.class.equals(type)) {
            return Collections.emptySet();
        }
        if (!type.isPrimitive()) {
            return null;
        }
        if (Void.TYPE.equals(type)) {
            return null;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.FALSE;
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE.equals(type)) {
            return (byte)0;
        }
        if (Short.TYPE.equals(type)) {
            return (short)0;
        }
        if (Integer.TYPE.equals(type)) {
            return 0;
        }
        if (Long.TYPE.equals(type)) {
            return 0L;
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(type)) {
            return 0.0;
        }
        throw new AssertionError();
    }

    public synchronized Object proceed() throws Exception {
        try {
            Class<?> resultType;
            Object it;
            Method im;
            Object result;
            Class<?> responseType = this.method.getReturnType();
            do {
                if (this.count >= this.invokeTarget.size()) {
                    return MethodInvocationChain.nil(responseType);
                }
                im = this.invokeMethod.get(this.count);
                it = this.invokeTarget.get(this.count);
                ++this.count;
                Class<?>[] param = im.getParameterTypes();
                resultType = im.getReturnType();
                if (param.length != 1 || !MethodInvocation.class.isAssignableFrom(param[0])) continue;
                result = im.invoke(it, this);
                return MethodInvocationChain.cast(result, resultType, responseType);
            } while (MethodInvocationChain.isNil(result = im.invoke(it, this.getArguments(im)), resultType));
            return MethodInvocationChain.cast(result, resultType, responseType);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new BehaviourException(cause);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public synchronized String toString() {
        String params = Arrays.asList(this.arguments).toString();
        String values = params.substring(1, params.length() - 1);
        return this.method.getName() + "(" + values + ")";
    }
}

