/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RoleMatcher
implements Cloneable {
    private ConcurrentNavigableMap<String, List<Class<?>>> pathprefix = new ConcurrentSkipListMap();
    private ConcurrentNavigableMap<String, List<Class<?>>> uriprefix = new ConcurrentSkipListMap();
    private ConcurrentMap<String, List<Class<?>>> paths = new ConcurrentHashMap();
    private ConcurrentMap<String, List<Class<?>>> uris = new ConcurrentHashMap();
    private boolean empty = true;

    public RoleMatcher clone() {
        RoleMatcher cloned = new RoleMatcher();
        for (String key : this.pathprefix.keySet()) {
            for (Class role : (List)this.pathprefix.get(key)) {
                cloned.addRoles(key + '*', role);
            }
        }
        for (String key : this.uriprefix.keySet()) {
            for (Class role : (List)this.uriprefix.get(key)) {
                cloned.addRoles(key + '*', role);
            }
        }
        for (String key : this.paths.keySet()) {
            for (Class role : (List)this.paths.get(key)) {
                cloned.addRoles(key, role);
            }
        }
        for (String key : this.uris.keySet()) {
            for (Class role : (List)this.uris.get(key)) {
                cloned.addRoles(key, role);
            }
        }
        return cloned;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void addRoles(String pattern, Class<?> role) {
        if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            if (prefix.startsWith("/")) {
                this.add(this.paths, prefix, role);
                this.add(this.pathprefix, prefix, role);
            } else {
                this.add(this.uris, prefix, role);
                this.add(this.uriprefix, prefix, role);
            }
        } else if (pattern.startsWith("/")) {
            this.add(this.paths, pattern, role);
        } else {
            this.add(this.uris, pattern, role);
        }
        this.empty = false;
    }

    public void findRoles(String uri, Collection<Class<?>> roles) {
        List list = (List)this.uris.get(uri);
        if (list != null) {
            roles.addAll(list);
        }
        this.findRoles(this.uriprefix, uri, roles);
        int idx = uri.indexOf("://");
        if (idx > 0) {
            String path = uri.substring(uri.indexOf(47, idx + 3));
            list = (List)this.paths.get(path);
            if (list != null) {
                roles.addAll(list);
            }
            this.findRoles(this.pathprefix, path, roles);
        }
    }

    private void add(ConcurrentMap<String, List<Class<?>>> map, String pattern, Class<?> role) {
        List o;
        List<Class<Object>> list = (CopyOnWriteArrayList)map.get(pattern);
        if (list == null && (o = (List)map.putIfAbsent(pattern, list = new CopyOnWriteArrayList())) != null) {
            list = o;
        }
        list.add(role);
    }

    private boolean findRoles(NavigableMap<String, List<Class<?>>> map, String full, Collection<Class<?>> roles) {
        int idx;
        String key = map.lowerKey(full);
        if (key == null) {
            return false;
        }
        if (full.startsWith(key)) {
            roles.addAll((Collection)map.get(key));
            this.findRoles(map, key, roles);
            return true;
        }
        for (idx = 0; idx < full.length() && idx < key.length() && full.charAt(idx) == key.charAt(idx); ++idx) {
        }
        String prefix = full.substring(0, idx);
        if (map.containsKey(prefix)) {
            roles.addAll((Collection)map.get(prefix));
            if (idx > 1) {
                this.findRoles(map, prefix, roles);
            }
            return true;
        }
        if (idx > 1) {
            return this.findRoles(map, prefix, roles);
        }
        return false;
    }
}

