/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.enilink.composition.mappers.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRoleMapper<T>
implements Cloneable {
    private static final String BASE_TYPE = "http://www.w3.org/2000/01/rdf-schema#Resource";
    private final Logger logger = LoggerFactory.getLogger(SimpleRoleMapper.class);
    private T baseType;
    private boolean empty = true;
    private Map<T, List<Class<?>>> roles = new ConcurrentHashMap(256);
    private Map<T, Boolean> unregisteredTypes = new ConcurrentHashMap<T, Boolean>();

    public SimpleRoleMapper<T> clone() {
        try {
            SimpleRoleMapper cloned = (SimpleRoleMapper)super.clone();
            cloned.roles = this.clone(this.roles);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <K, V> Map<K, List<V>> clone(Map<K, List<V>> map) {
        HashMap<K, List<V>> cloned = new HashMap<K, List<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new ArrayList((Collection)entry.getValue()));
        }
        return cloned;
    }

    public void setTypeFactory(TypeFactory<T> typeFactory) {
        this.baseType = typeFactory.createType(BASE_TYPE);
        List list = Collections.emptyList();
        this.roles.put(this.baseType, list);
    }

    public T getBaseType() {
        return this.baseType;
    }

    public Collection<Class<?>> findAllRoles() {
        ArrayList list = new ArrayList(this.roles.size());
        for (List<Class<?>> v : this.roles.values()) {
            list.addAll(v);
        }
        return list;
    }

    public void findRoles(T type, Collection<Class<?>> classes) {
        List<Class<?>> rolesForType = this.roles.get(type);
        if (rolesForType == null) {
            this.unregistered(type);
            classes.addAll(this.findBaseRoles());
        } else {
            classes.addAll(rolesForType);
        }
    }

    public void findRoles(Collection<T> types, Collection<Class<?>> classes) {
        boolean found = false;
        for (T type : types) {
            List<Class<?>> rolesForType = this.roles.get(type);
            if (rolesForType == null) {
                this.unregistered(type);
                continue;
            }
            found = true;
            classes.addAll(rolesForType);
        }
        if (!found) {
            classes.addAll(this.findBaseRoles());
        }
    }

    public boolean isTypeRecorded(T type) {
        return this.roles.containsKey(type);
    }

    public synchronized Set<Class<?>> recordRoles(Set<Class<?>> newRoles, T uri) {
        List<Class<?>> existingRoles = this.roles.get(uri);
        HashSet changed = new HashSet();
        if (existingRoles == null) {
            changed.addAll(this.findBaseRoles());
        } else {
            changed.addAll(existingRoles);
        }
        changed.addAll(newRoles);
        if (existingRoles == null || changed.size() != existingRoles.size()) {
            this.empty &= uri.equals(this.baseType);
            this.roles.put(uri, Arrays.asList(changed.toArray(new Class[changed.size()])));
        }
        return changed;
    }

    public synchronized void recordBaseRole(Class<?> role) {
        for (Map.Entry<T, List<Class<?>>> e : this.roles.entrySet()) {
            List<Class<?>> set = e.getValue();
            boolean contains = false;
            for (Class<?> c : set) {
                if (!role.equals(c)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            ArrayList ar = new ArrayList(set.size() + 1);
            ar.addAll(set);
            ar.add(role);
            e.setValue(ar);
        }
    }

    private Collection<Class<?>> findBaseRoles() {
        Collection baseRoles = this.roles.get(this.baseType);
        return baseRoles == null ? Collections.emptySet() : baseRoles;
    }

    private void unregistered(T type) {
        if (!this.unregisteredTypes.containsKey(type)) {
            this.unregisteredTypes.put(type, Boolean.TRUE);
            this.logger.info("Unregistered type {}", type);
        }
    }
}

