/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.mappers;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper<T>
implements Cloneable {
    private final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private Map<Class<?>, T> types = new ConcurrentHashMap(256);

    public TypeMapper<T> clone() {
        try {
            TypeMapper cloned = (TypeMapper)super.clone();
            cloned.types = new ConcurrentHashMap(this.types);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public T findType(Class<?> role) {
        return this.types.get(role);
    }

    public synchronized void recordRole(Class<?> role, T type) {
        assert (type != null);
        if (!this.types.containsKey(role)) {
            this.types.put(role, type);
            if (this.logger.isDebugEnabled()) {
                String sn = role.getSimpleName();
                String cn = role.getName().replace('.', '/') + ".class";
                ClassLoader cl = role.getClassLoader();
                if (cl == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                URL location = cl.getResource(cn);
                this.logger.debug("Role {} loaded from {}", (Object)sn, (Object)location);
            }
        }
    }
}

