/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import com.google.inject.Inject;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.LinkedHashBindings;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerUpdate;
import net.enilink.komma.internal.rdf4j.SparqlUpdateExecutor;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;

public class RDF4JUpdate
implements IDataManagerUpdate {
    @Inject
    RDF4JValueConverter valueConverter;
    @Inject
    ValueFactory vf;
    final IDataManager dm;
    final ParsedUpdate parsedUpdate;
    final String baseURI;
    final boolean includeInferred;
    final LinkedHashBindings<IValue> bindings = new LinkedHashBindings();
    final IReference[] readContexts;
    final IReference[] modifyContexts;

    public RDF4JUpdate(IDataManager dm, String update, String baseURI, boolean includeInferred, IReference[] readContexts, IReference[] modifyContexts) {
        this.dm = dm;
        try {
            this.parsedUpdate = QueryParserUtil.parseUpdate((QueryLanguage)QueryLanguage.SPARQL, (String)update, (String)baseURI);
        }
        catch (MalformedQueryException e) {
            throw new KommaException((Throwable)e);
        }
        catch (UnsupportedQueryLanguageException e) {
            throw new KommaException((Throwable)e);
        }
        this.baseURI = baseURI;
        this.includeInferred = includeInferred;
        this.readContexts = readContexts;
        this.modifyContexts = modifyContexts;
    }

    public void execute() {
        SparqlUpdateExecutor updateExecutor = new SparqlUpdateExecutor(this.dm, this.valueConverter, this.vf);
        boolean localTransaction = !this.dm.getTransaction().isActive();
        try {
            if (localTransaction) {
                this.dm.getTransaction().begin();
            }
            for (UpdateExpr updateExpr : this.parsedUpdate.getUpdateExprs()) {
                Dataset dataset = (Dataset)this.parsedUpdate.getDatasetMapping().get(updateExpr);
                updateExecutor.executeUpdate(updateExpr, this.baseURI, this.readContexts, this.modifyContexts, (IBindings<IValue>)this.bindings, this.includeInferred);
            }
            if (localTransaction) {
                this.dm.getTransaction().commit();
            }
        }
        catch (RuntimeException e) {
            if (localTransaction && this.dm.getTransaction().isActive()) {
                this.dm.getTransaction().rollback();
            }
            throw new RuntimeException(e);
        }
    }

    public IDataManagerUpdate setParameter(String name, IValue value) {
        this.bindings.put(name, (Object)value);
        return this;
    }
}

