/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IStatementPattern;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.LinkedHashBindings;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerQuery;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.Add;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Copy;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.Move;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.StatementPatternCollector;
import org.eclipse.rdf4j.queryrender.sparql.SparqlTupleExprRenderer;
import org.eclipse.rdf4j.repository.sail.helpers.SPARQLUpdateDataBlockParser;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlUpdateExecutor {
    private final Logger logger = LoggerFactory.getLogger(SparqlUpdateExecutor.class);
    private final IDataManager dm;
    private final RDF4JValueConverter valueConverter;
    private final ValueFactory vf;
    static final Collection<IStatementPattern> ANY_STATEMENT = Collections.singleton(new net.enilink.komma.core.StatementPattern(null, null, null));

    public SparqlUpdateExecutor(IDataManager dm, RDF4JValueConverter valueConverter, ValueFactory vf) {
        this.dm = dm;
        this.valueConverter = valueConverter;
        this.vf = vf;
    }

    public void executeUpdate(UpdateExpr updateExpr, String baseURI, IReference[] readContexts, IReference[] modifyContexts, IBindings<IValue> bindings, boolean includeInferred) throws KommaException {
        UpdateContext uc = new UpdateContext(updateExpr, baseURI, readContexts, modifyContexts, bindings, includeInferred);
        this.logger.trace("Incoming update expression:\n{}", (Object)uc);
        if (updateExpr instanceof Load) {
            this.executeLoad((Load)updateExpr, uc);
        } else if (updateExpr instanceof Modify) {
            this.executeModify((Modify)updateExpr, uc);
        } else if (updateExpr instanceof InsertData) {
            this.executeInsertData((InsertData)updateExpr, uc);
        } else if (updateExpr instanceof DeleteData) {
            this.executeDeleteData((DeleteData)updateExpr, uc);
        } else if (updateExpr instanceof Clear) {
            this.executeClear((Clear)updateExpr, uc);
        } else if (updateExpr instanceof Create) {
            this.executeCreate((Create)updateExpr, uc);
        } else if (updateExpr instanceof Copy) {
            this.executeCopy((Copy)updateExpr, uc);
        } else if (updateExpr instanceof Add) {
            this.executeAdd((Add)updateExpr, uc);
        } else if (updateExpr instanceof Move) {
            this.executeMove((Move)updateExpr, uc);
        }
    }

    protected void executeLoad(Load load, UpdateContext uc) throws KommaException {
        Value source = load.getSource().getValue();
        Value graph = load.getGraph() != null ? load.getGraph().getValue() : null;
    }

    protected void executeCreate(Create create, UpdateContext uc) throws KommaException {
        Value graphValue = create.getGraph().getValue();
        if (graphValue instanceof Resource) {
            Resource namedGraph = (Resource)graphValue;
            IDataManagerQuery contextQuery = this.dm.createQuery("ask { graph ?g { ?s ?p ?o } }", null, false, new IReference[0]);
            try (IExtendedIterator result = contextQuery.evaluate();){
                if (Boolean.TRUE.equals(result.next())) {
                    throw new KommaException("Named graph " + namedGraph + " already exists. ");
                }
            }
        }
    }

    protected void executeCopy(Copy copy, UpdateContext uc) throws KommaException {
        Resource destination;
        ValueConstant sourceGraph = copy.getSourceGraph();
        ValueConstant destinationGraph = copy.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.dm.remove(ANY_STATEMENT, new IReference[]{this.valueConverter.fromRdf4j(destination)});
        try (IExtendedIterator stmts = this.dm.match(null, null, null, uc.includeInferred, new IReference[]{this.valueConverter.fromRdf4j(source)});){
            this.dm.add((Iterable)stmts, new IReference[]{this.valueConverter.fromRdf4j(destination)});
        }
    }

    protected void executeAdd(Add add, UpdateContext uc) throws KommaException {
        Resource destination;
        ValueConstant sourceGraph = add.getSourceGraph();
        ValueConstant destinationGraph = add.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        try (IExtendedIterator stmts = this.dm.match(null, null, null, uc.includeInferred, new IReference[]{this.valueConverter.fromRdf4j(source)});){
            this.dm.add((Iterable)stmts, new IReference[]{this.valueConverter.fromRdf4j(destination)});
        }
    }

    protected void executeMove(Move move, UpdateContext uc) throws KommaException {
        Resource destination;
        ValueConstant sourceGraph = move.getSourceGraph();
        ValueConstant destinationGraph = move.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.dm.remove(ANY_STATEMENT, new IReference[]{this.valueConverter.fromRdf4j(destination)});
        try (IExtendedIterator stmts = this.dm.match(null, null, null, uc.includeInferred, new IReference[]{this.valueConverter.fromRdf4j(source)});){
            this.dm.add((Iterable)stmts, new IReference[]{this.valueConverter.fromRdf4j(destination)});
            this.dm.remove((Iterable)stmts, new IReference[]{this.valueConverter.fromRdf4j(source)});
        }
    }

    protected void executeClear(Clear clearExpr, UpdateContext uc) throws KommaException {
        block9: {
            try {
                ValueConstant graph = clearExpr.getGraph();
                if (graph != null) {
                    Resource context = (Resource)graph.getValue();
                    this.dm.remove(ANY_STATEMENT, new IReference[]{this.valueConverter.fromRdf4j(context)});
                } else {
                    StatementPattern.Scope scope = clearExpr.getScope();
                    if (StatementPattern.Scope.NAMED_CONTEXTS.equals((Object)scope)) {
                        IDataManagerQuery contextQuery = this.dm.createQuery("select distinct ?g where { graph ?g { ?s ?p ?o } }", null, false, new IReference[0]);
                        for (IReference ctx : contextQuery.evaluate().mapWith((IMap)new IMap<Object, IReference>(){

                            public IReference map(Object value) {
                                return SparqlUpdateExecutor.this.valueConverter.fromRdf4j((Resource)((IBindings)value).get("g"));
                            }
                        }).toList()) {
                            this.dm.remove(ANY_STATEMENT, new IReference[]{ctx});
                        }
                    } else if (StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)scope)) {
                        this.dm.remove(ANY_STATEMENT, new IReference[]{null});
                    } else {
                        this.dm.remove(ANY_STATEMENT, new IReference[0]);
                    }
                }
            }
            catch (KommaException e) {
                if (clearExpr.isSilent()) break block9;
                throw e;
            }
        }
    }

    protected List<IStatement> dataBlockToStatements(String dataBlock, boolean allowBNodes, UpdateContext uc) throws KommaException {
        final ArrayList<IStatement> stmts = new ArrayList<IStatement>();
        SPARQLUpdateDataBlockParser parser = new SPARQLUpdateDataBlockParser(this.vf);
        parser.setAllowBlankNodes(allowBNodes);
        parser.setRDFHandler((RDFHandler)new AbstractRDFHandler(){

            public void handleStatement(Statement stmt) throws RDFHandlerException {
                stmts.add(new net.enilink.komma.core.Statement(SparqlUpdateExecutor.this.valueConverter.fromRdf4j(stmt.getSubject()), SparqlUpdateExecutor.this.valueConverter.fromRdf4j((Resource)stmt.getPredicate()), (Object)SparqlUpdateExecutor.this.valueConverter.fromRdf4j(stmt.getObject()), SparqlUpdateExecutor.this.valueConverter.fromRdf4j(stmt.getContext())));
            }
        });
        try {
            parser.parse((Reader)new StringReader(dataBlock), uc.baseURI);
        }
        catch (RDFParseException rpe) {
            throw new KommaException((Throwable)rpe);
        }
        catch (RDFHandlerException rhe) {
            throw new KommaException((Throwable)rhe);
        }
        catch (IOException ioe) {
            throw new KommaException((Throwable)ioe);
        }
        return stmts;
    }

    protected void executeInsertData(InsertData insertDataExpr, UpdateContext uc) throws KommaException {
        this.dm.add(this.dataBlockToStatements(insertDataExpr.getDataBlock(), true, uc), uc.modifyContexts);
    }

    protected void executeDeleteData(DeleteData deleteDataExpr, UpdateContext uc) throws KommaException {
        this.dm.remove(this.dataBlockToStatements(deleteDataExpr.getDataBlock(), false, uc), uc.modifyContexts);
    }

    protected IExtendedIterator<?> evaluateSparql(TupleExpr tupleExpr, UpdateContext uc) {
        try {
            SparqlTupleExprRenderer renderer = new SparqlTupleExprRenderer();
            String sparql = renderer.render(tupleExpr);
            return this.dm.createQuery(sparql, uc.baseURI, uc.includeInferred, uc.readContexts).evaluate();
        }
        catch (KommaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    protected void executeModify(Modify modify, UpdateContext uc) throws KommaException {
        TupleExpr whereClause = modify.getWhereExpr();
        if (!(whereClause instanceof QueryRoot)) {
            whereClause = new QueryRoot(whereClause);
        }
        try (IExtendedIterator<IBindings<IValue>> sourceBindings = this.evaluateWhereClause(whereClause, uc);){
            for (IBindings bs : sourceBindings) {
                this.deleteBoundTriples((IBindings<IValue>)bs, modify.getDeleteExpr(), uc);
                this.insertBoundTriples((IBindings<IValue>)bs, modify.getInsertExpr(), uc);
            }
        }
    }

    private IExtendedIterator<IBindings<IValue>> evaluateWhereClause(final TupleExpr whereClause, final UpdateContext uc) throws KommaException {
        return this.evaluateSparql(whereClause, uc).mapWith((IMap)new IMap<Object, IBindings<IValue>>(){

            public IBindings<IValue> map(Object value) {
                IBindings sourceBindings = (IBindings)value;
                if (whereClause instanceof SingletonSet && sourceBindings.getKeys().isEmpty() && uc.bindings != null) {
                    return uc.bindings;
                }
                HashSet uniqueBindings = new HashSet(uc.bindings.getKeys());
                uniqueBindings.removeAll(sourceBindings.getKeys());
                if (uniqueBindings.size() > 0) {
                    LinkedHashBindings mergedSet = new LinkedHashBindings();
                    for (String bindingName : sourceBindings.getKeys()) {
                        mergedSet.put(bindingName, sourceBindings.get(bindingName));
                    }
                    for (String bindingName : uniqueBindings) {
                        mergedSet.put(bindingName, uc.bindings.get(bindingName));
                    }
                    return mergedSet;
                }
                return sourceBindings;
            }
        });
    }

    private void deleteBoundTriples(IBindings<IValue> whereBinding, TupleExpr deleteClause, UpdateContext uc) throws KommaException {
        if (deleteClause != null) {
            List deletePatterns = StatementPatternCollector.process((QueryModelNode)deleteClause);
            for (StatementPattern deletePattern : deletePatterns) {
                IReference subject = (IReference)this.getValueForVar(deletePattern.getSubjectVar(), whereBinding);
                IReference predicate = (IReference)this.getValueForVar(deletePattern.getPredicateVar(), whereBinding);
                IValue object = this.getValueForVar(deletePattern.getObjectVar(), whereBinding);
                IReference context = null;
                if (deletePattern.getContextVar() != null) {
                    context = (IReference)this.getValueForVar(deletePattern.getContextVar(), whereBinding);
                }
                if (subject == null || predicate == null || object == null) continue;
                net.enilink.komma.core.StatementPattern stmt = new net.enilink.komma.core.StatementPattern(subject, predicate, (Object)object);
                if (context != null) {
                    this.dm.remove(Collections.singleton(stmt), new IReference[]{context});
                    continue;
                }
                this.dm.remove(Collections.singleton(stmt), uc.modifyContexts);
            }
        }
    }

    private void insertBoundTriples(IBindings<IValue> whereBinding, TupleExpr insertClause, UpdateContext uc) throws KommaException {
        if (insertClause != null) {
            List insertPatterns = StatementPatternCollector.process((QueryModelNode)insertClause);
            HashMap<String, IReference> bnodeMapping = new HashMap<String, IReference>();
            for (StatementPattern insertPattern : insertPatterns) {
                net.enilink.komma.core.Statement toBeInserted = this.createStatementFromPattern(insertPattern, whereBinding, bnodeMapping);
                if (toBeInserted == null) continue;
                IReference[] with = uc.modifyContexts;
                if (with == null && toBeInserted.getContext() == null) {
                    this.dm.add((Iterable)toBeInserted, new IReference[0]);
                    continue;
                }
                if (toBeInserted.getContext() == null) {
                    this.dm.add((Iterable)toBeInserted, with);
                    continue;
                }
                this.dm.add((Iterable)toBeInserted, new IReference[]{toBeInserted.getContext()});
            }
        }
    }

    private net.enilink.komma.core.Statement createStatementFromPattern(StatementPattern pattern, IBindings<IValue> sourceBindings, Map<String, IReference> bnodeMapping) throws KommaException {
        IReference subject = null;
        IReference predicate = null;
        IValue object = null;
        IReference context = null;
        if (pattern.getSubjectVar().hasValue()) {
            subject = this.valueConverter.fromRdf4j((Resource)pattern.getSubjectVar().getValue());
        } else {
            subject = (IReference)sourceBindings.get(pattern.getSubjectVar().getName());
            if (subject == null && pattern.getSubjectVar().isAnonymous() && (subject = bnodeMapping.get(pattern.getSubjectVar().getName())) == null) {
                subject = this.dm.blankNode();
                bnodeMapping.put(pattern.getSubjectVar().getName(), subject);
            }
        }
        predicate = pattern.getPredicateVar().hasValue() ? this.valueConverter.fromRdf4j((Resource)pattern.getPredicateVar().getValue()) : (IReference)sourceBindings.get(pattern.getPredicateVar().getName());
        if (pattern.getObjectVar().hasValue()) {
            object = this.valueConverter.fromRdf4j(pattern.getObjectVar().getValue());
        } else {
            object = (IValue)sourceBindings.get(pattern.getObjectVar().getName());
            if (object == null && pattern.getObjectVar().isAnonymous() && (object = (IValue)bnodeMapping.get(pattern.getSubjectVar().getName())) == null) {
                object = this.dm.blankNode();
                bnodeMapping.put(pattern.getObjectVar().getName(), (IReference)object);
            }
        }
        if (pattern.getContextVar() != null) {
            context = pattern.getContextVar().hasValue() ? this.valueConverter.fromRdf4j((Resource)pattern.getContextVar().getValue()) : (IReference)sourceBindings.get(pattern.getContextVar().getName());
        }
        net.enilink.komma.core.Statement st = null;
        if (subject != null && predicate != null && object != null) {
            st = context != null ? new net.enilink.komma.core.Statement(subject, predicate, (Object)object, context) : new net.enilink.komma.core.Statement(subject, predicate, (Object)object);
        }
        return st;
    }

    private IValue getValueForVar(Var var, IBindings<IValue> bindings) throws KommaException {
        if (var.hasValue()) {
            return this.valueConverter.fromRdf4j(var.getValue());
        }
        return (IValue)bindings.get(var.getName());
    }

    static class UpdateContext {
        final UpdateExpr updateExpr;
        final String baseURI;
        final IReference[] readContexts;
        final IReference[] modifyContexts;
        final IBindings<IValue> bindings;
        final boolean includeInferred;

        UpdateContext(UpdateExpr updateExpr, String baseURI, IReference[] readContexts, IReference[] modifyContexts, IBindings<IValue> bindings, boolean includeInferred) {
            this.updateExpr = updateExpr;
            this.baseURI = baseURI;
            this.readContexts = readContexts;
            this.modifyContexts = modifyContexts;
            this.bindings = bindings;
            this.includeInferred = includeInferred;
        }
    }
}

