/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j.result;

import net.enilink.commons.iterator.NiceIterator;
import net.enilink.komma.core.KommaException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

public abstract class RDF4JResult<S, T>
extends NiceIterator<T> {
    protected CloseableIteration<S, ? extends Exception> delegate;
    protected boolean open = true;
    private S current;

    public RDF4JResult(CloseableIteration<S, ? extends Exception> delegate) {
        this.delegate = delegate;
        if (!this.hasNext()) {
            this.close();
        }
    }

    public void close() {
        if (this.open) {
            try {
                this.delegate.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KommaException((Throwable)e);
            }
            finally {
                this.open = false;
            }
        }
    }

    protected abstract T convert(S var1) throws Exception;

    public boolean hasNext() {
        try {
            if (this.delegate.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public T next() {
        try {
            this.current = this.delegate.next();
            if (this.current == null) {
                return null;
            }
            return this.convert(this.current);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    public void remove() {
        try {
            this.remove(this.current);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    protected void remove(S element) throws Exception {
        throw new UnsupportedOperationException();
    }
}

