/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.rdf4j.result;

import com.google.inject.Inject;
import java.util.List;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.ITupleResult;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.LinkedHashBindings;
import net.enilink.komma.internal.rdf4j.result.RDF4JResult;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class RDF4JTupleResult
extends RDF4JResult<BindingSet, IBindings<IValue>>
implements ITupleResult<IBindings<IValue>> {
    protected RDF4JValueConverter valueConverter;

    public RDF4JTupleResult(TupleQueryResult result) {
        super(result);
    }

    @Override
    protected IBindings<IValue> convert(BindingSet element) throws Exception {
        LinkedHashBindings result = new LinkedHashBindings(element.size());
        for (String name : this.getBindingNames()) {
            IValue value = this.valueConverter.fromRdf4j(element.getValue(name));
            if (value == null) continue;
            result.put(name, (Object)value);
        }
        return result;
    }

    public List<String> getBindingNames() {
        try {
            return ((TupleQueryResult)this.delegate).getBindingNames();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    public void setValueConverter(RDF4JValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }
}

