/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.rdf4j;

import com.google.inject.Inject;
import com.google.inject.Injector;
import net.enilink.komma.core.IDialect;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.SparqlStandardDialect;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerFactory;
import net.enilink.komma.internal.rdf4j.RDF4JRepositoryDataManager;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;

public class RDF4JDataManagerFactory
implements IDataManagerFactory {
    @Inject
    protected Injector injector;
    @Inject
    protected Repository repository;
    @Inject(optional=true)
    protected IDialect dialect;

    public IDataManager get() {
        return (IDataManager)this.injector.getInstance(RDF4JRepositoryDataManager.class);
    }

    public IDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.createDialect();
        }
        return this.dialect;
    }

    protected IDialect createDialect() {
        return new SparqlStandardDialect();
    }

    public void close() {
        if (this.repository != null) {
            try {
                this.repository.shutDown();
                this.repository = null;
            }
            catch (RepositoryException e) {
                throw new KommaException((Throwable)e);
            }
        }
    }
}

