/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.rdf4j;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.URI;
import net.enilink.komma.internal.rdf4j.RDF4JLiteral;
import net.enilink.komma.internal.rdf4j.RDF4JReference;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleDataset;

public class RDF4JValueConverter {
    private static final IRI[] EMPTY_IRIS = new IRI[0];
    private static final IRI[] NULL_IRI = new IRI[]{null};
    protected ValueFactory valueFactory;
    protected final Map<String, BNode> bnodeMap = new HashMap<String, BNode>();

    @Inject
    public RDF4JValueConverter(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Dataset createDataset(IReference[] readContexts, IReference[] modifyContexts) {
        IRI[] rdf4jContexts;
        SimpleDataset ds = new SimpleDataset();
        for (IRI graph : this.toRdf4jIRI(readContexts)) {
            ds.addDefaultGraph(graph);
            if (graph == null) continue;
            ds.addNamedGraph(graph);
        }
        for (IRI graph : rdf4jContexts = this.toRdf4jIRI(modifyContexts)) {
            ds.addDefaultRemoveGraph(graph);
        }
        if (rdf4jContexts.length > 0) {
            ds.setDefaultInsertGraph(rdf4jContexts[0]);
        }
        return ds;
    }

    public IReference fromRdf4j(Resource resource) {
        return (IReference)this.fromRdf4j((Value)resource);
    }

    public IValue fromRdf4j(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Resource) {
            return new RDF4JReference((Resource)value);
        }
        return new RDF4JLiteral((Literal)value);
    }

    public BindingSet toRdf4j(IBindings<?> bindings) {
        MapBindingSet bindingSet = new MapBindingSet();
        for (String key : bindings.getKeys()) {
            bindingSet.addBinding(key, this.toRdf4j((IValue)bindings.get(key)));
        }
        return bindingSet;
    }

    public Statement toRdf4j(IStatement next) {
        return this.valueFactory.createStatement(this.toRdf4j(next.getSubject()), this.toRdf4j(next.getPredicate().getURI()), this.toRdf4j((IValue)next.getObject()), this.toRdf4j(next.getContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource toRdf4j(IReference reference) {
        URI uri;
        if (reference == null) {
            return null;
        }
        if (reference instanceof IReferenceable) {
            reference = ((IReferenceable)reference).getReference();
        }
        if (reference instanceof RDF4JReference) {
            Resource resource = ((RDF4JReference)reference).getRDF4JResource();
            if (resource instanceof BNode && ((BNode)resource).getID().startsWith("new-")) {
                reference = new BlankNode(reference.toString());
            } else {
                return resource;
            }
        }
        if ((uri = reference.getURI()) != null) {
            return this.toRdf4j(reference.getURI());
        }
        String valueAsString = reference.toString();
        if (valueAsString.startsWith("_:")) {
            String id = valueAsString.substring(2);
            if (id.startsWith("new-")) {
                Map<String, BNode> map = this.bnodeMap;
                synchronized (map) {
                    BNode bnode = this.bnodeMap.get(id);
                    if (bnode == null) {
                        bnode = this.valueFactory.createBNode();
                        this.bnodeMap.put(id, bnode);
                    }
                    return bnode;
                }
            }
            return this.valueFactory.createBNode(id);
        }
        throw new KommaException("Cannot convert blank node with nominal value '" + valueAsString + "' to RDF4J blank node.");
    }

    public Value toRdf4j(IValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IReference) {
            return this.toRdf4j((IReference)value);
        }
        if (value instanceof ILiteral) {
            if (value instanceof RDF4JLiteral) {
                return ((RDF4JLiteral)value).getRDF4JLiteral();
            }
            ILiteral literal = (ILiteral)value;
            String language = literal.getLanguage();
            if (language != null) {
                return this.valueFactory.createLiteral(literal.getLabel(), language);
            }
            return this.valueFactory.createLiteral(literal.getLabel(), this.toRdf4j(literal.getDatatype()));
        }
        throw new KommaException("Cannot convert object of type: " + value.getClass().getName());
    }

    public IRI toRdf4j(URI uri) {
        if (uri == null) {
            return null;
        }
        return this.valueFactory.createIRI(uri.toString());
    }

    public IRI[] toRdf4jIRI(IReference ... references) {
        if (references.length == 0) {
            return EMPTY_IRIS;
        }
        if (references.length == 1 && references[0] == null) {
            return NULL_IRI;
        }
        ArrayList<IRI> iris = new ArrayList<IRI>(references.length);
        for (IReference ref : references) {
            if (ref == null) {
                iris.add(null);
                continue;
            }
            Resource resource = this.toRdf4j(ref);
            if (!(resource instanceof IRI)) continue;
            iris.add((IRI)resource);
        }
        return iris.toArray(new IRI[iris.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<String, BNode> map = this.bnodeMap;
        synchronized (map) {
            this.bnodeMap.clear();
        }
    }
}

