/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.sparql;

import com.google.inject.Inject;
import java.lang.reflect.Modifier;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.asm.BehaviourClassNode;
import net.enilink.composition.asm.BehaviourMethodProcessor;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.Types;
import net.enilink.composition.asm.util.BehaviourMethodGenerator;
import net.enilink.composition.asm.util.MethodNodeGenerator;
import net.enilink.composition.exceptions.BehaviourException;
import net.enilink.composition.properties.PropertyMapper;
import net.enilink.composition.properties.sparql.SPARQLQueryOptimizer;
import net.enilink.composition.properties.sparql.Sparql;
import net.enilink.komma.core.IEntityManager;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class SparqlBehaviourMethodProcessor
implements BehaviourMethodProcessor,
Opcodes,
Types {
    public static Type MANAGER_TYPE = Type.getType(IEntityManager.class);
    public static Method GET_MANAGER = new Method("getContext", Type.getMethodDescriptor((Type)MANAGER_TYPE, (Type[])new Type[0]));
    @Inject
    private PropertyMapper propertyMapper;

    public boolean implementsMethod(Class<?> targetClass, java.lang.reflect.Method method) {
        return method.isAnnotationPresent(Sparql.class) && Modifier.isAbstract(method.getModifiers());
    }

    public boolean appliesTo(BehaviourClassNode classNode, ExtendedMethod method) {
        return method.getOverriddenMethod().isAnnotationPresent(Sparql.class) && method.instructions.size() == 0;
    }

    public void initialize(BehaviourClassNode classNode) throws Exception {
        FieldNode contextField = new FieldNode(2, "context", MANAGER_TYPE.getDescriptor(), null, null);
        contextField.visitAnnotation(Type.getDescriptor(Inject.class), true);
        classNode.fields.add(contextField);
        MethodNode mn = new MethodNode(2, GET_MANAGER.getName(), GET_MANAGER.getDescriptor(), null, null);
        MethodNodeGenerator gen = new MethodNodeGenerator(mn);
        gen.loadThis();
        gen.getField(classNode.getType(), "context", MANAGER_TYPE);
        gen.returnValue();
        gen.endMethod();
        classNode.methods.add(mn);
    }

    public void process(BehaviourClassNode classNode, ExtendedMethod method) throws Exception {
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(method);
        String sparql = method.getOverriddenMethod().getAnnotation(Sparql.class).value();
        String base = method.getOverriddenMethod().getDeclaringClass().isAnnotationPresent(Iri.class) ? method.getOverriddenMethod().getDeclaringClass().getAnnotation(Iri.class).value() : "java:" + method.getOverriddenMethod().getDeclaringClass().getName();
        Label tryLabel = gen.mark();
        SPARQLQueryOptimizer oqo = new SPARQLQueryOptimizer();
        oqo.implementQuery(sparql, base, this.propertyMapper, method.getOverriddenMethod(), gen);
        Label catchLabel = gen.mark();
        Type runtimeException = Type.getType(RuntimeException.class);
        gen.catchException(tryLabel, catchLabel, runtimeException);
        gen.throwException();
        gen.catchException(tryLabel, catchLabel, Type.getType(Exception.class));
        int exceptionVar = gen.newLocal(Type.getType(Exception.class));
        gen.storeLocal(exceptionVar);
        Type behaviourException = Type.getType(BehaviourException.class);
        gen.newInstance(behaviourException);
        gen.dup();
        gen.loadLocal(exceptionVar);
        gen.invokeConstructor(behaviourException, Method.getMethod((String)"void <init>(Throwable)"));
        gen.throwException();
    }
}

