/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.enilink.composition.annotations.Iri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapper {
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final String PROPERTIES = "META-INF/org.openrdf.properties";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static Logger logger = LoggerFactory.getLogger(PropertyMapper.class);
    private boolean readTypes;
    private Properties properties = new Properties();

    public PropertyMapper(ClassLoader cl, boolean readTypes) {
        this.loadProperties(cl);
        this.readTypes = readTypes;
    }

    public Collection<PropertyDescriptor> findProperties(Class<?> concept) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        while (concept != null) {
            for (Method method : concept.getDeclaredMethods()) {
                if (!this.isMappedGetter(method)) continue;
                properties.add(this.createPropertyDescriptor(method));
            }
            concept = concept.getSuperclass();
        }
        return properties;
    }

    public String findPredicate(Field field) {
        Class<?> dc = field.getDeclaringClass();
        String key = dc.getName() + "#" + field.getName();
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        Iri iri = field.getAnnotation(Iri.class);
        return iri == null ? null : iri.value();
    }

    public String findPredicate(PropertyDescriptor pd) {
        Method method = pd.getReadMethod();
        Class<?> dc = method.getDeclaringClass();
        String key = dc.getName() + "." + this.getPropertyName(method);
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        Method getter = method;
        Iri iri = getter.getAnnotation(Iri.class);
        return iri == null ? null : iri.value();
    }

    public Collection<PropertyDescriptor> findFunctionalProperties(Class<?> type) {
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        this.findFunctionalProperties(type, properties);
        return properties.values();
    }

    public Map<String, String> findEagerProperties(Class<?> type) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.findEagerProperties(type, properties);
        if (properties.isEmpty()) {
            return null;
        }
        if (this.readTypes) {
            properties.put("class", RDF_TYPE);
        }
        return properties;
    }

    private void findFunctionalProperties(Class<?> concept, Map<String, PropertyDescriptor> properties) {
        for (PropertyDescriptor pd : this.findProperties(concept)) {
            Class<?> type = pd.getPropertyType();
            if (Set.class.equals(type)) continue;
            properties.put(pd.getName(), pd);
        }
        for (Class<?> face : concept.getInterfaces()) {
            this.findFunctionalProperties(face, properties);
        }
        if (concept.getSuperclass() != null) {
            this.findFunctionalProperties(concept.getSuperclass(), properties);
        }
    }

    private Map<String, String> findEagerProperties(Class<?> concept, Map<String, String> properties) {
        for (PropertyDescriptor pd : this.findProperties(concept)) {
            Class<?> type = pd.getPropertyType();
            Type generic = pd.getReadMethod().getGenericReturnType();
            if (!this.isEagerPropertyType(generic, type)) continue;
            properties.put(pd.getName(), this.findPredicate(pd));
        }
        for (Class<?> face : concept.getInterfaces()) {
            this.findEagerProperties(face, properties);
        }
        if (concept.getSuperclass() == null) {
            return properties;
        }
        return this.findEagerProperties(concept.getSuperclass(), properties);
    }

    private boolean isEagerPropertyType(Type t, Class<?> type) {
        if (Set.class.equals(type)) {
            return false;
        }
        if (!this.readTypes) {
            return true;
        }
        if (type.isInterface()) {
            return false;
        }
        if (Object.class.equals(type)) {
            return false;
        }
        return !type.isAnnotationPresent(Iri.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(ClassLoader cl) {
        try {
            Enumeration<URL> resources = cl.getResources(PROPERTIES);
            while (resources.hasMoreElements()) {
                try (InputStream stream = resources.nextElement().openStream();){
                    this.properties.load(stream);
                }
                catch (IOException e) {
                    logger.warn(e.toString(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.warn(e.toString(), (Throwable)e);
        }
    }

    private boolean isMappedGetter(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.isAnnotationPresent(Iri.class)) {
            return true;
        }
        if (this.properties.isEmpty()) {
            return false;
        }
        String name = method.getDeclaringClass().getName();
        String key = name + "." + this.getPropertyName(method);
        return this.properties.containsKey(key);
    }

    private PropertyDescriptor createPropertyDescriptor(Method method) {
        String property = this.getPropertyName(method);
        Method setter = this.getSetterMethod(property, method);
        try {
            return new PropertyDescriptor(property, method, setter);
        }
        catch (IntrospectionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean isBeanGet(Method method) {
        String name = method.getName();
        return name.startsWith(GET_PREFIX) && name.length() > 3 && Character.isUpperCase(name.charAt(3));
    }

    private boolean isBeanIs(Method method) {
        String name = method.getName();
        boolean bool = method.getReturnType() == Boolean.TYPE;
        return bool && name.startsWith(IS_PREFIX) && name.length() > 2 && Character.isUpperCase(name.charAt(2));
    }

    private String getPropertyName(Method method) {
        String name = method.getName();
        if (this.isBeanGet(method)) {
            return PropertyMapper.decapitalize(name.substring(3));
        }
        if (this.isBeanIs(method)) {
            return PropertyMapper.decapitalize(name.substring(2));
        }
        return name;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private Method getSetterMethod(String property, Method getter) {
        try {
            Class<?> returnType;
            Method setter;
            Class<?> dc = getter.getDeclaringClass();
            Class<?> rt = getter.getReturnType();
            if (this.isBeanGet(getter) || this.isBeanIs(getter)) {
                String setterName = SET_PREFIX + PropertyMapper.capitalize(property);
                setter = dc.getDeclaredMethod(setterName, rt);
            } else {
                setter = dc.getDeclaredMethod(getter.getName(), rt);
            }
            if (setter != null && !Void.TYPE.equals(returnType = setter.getReturnType()) && !returnType.isAssignableFrom(dc)) {
                throw new AssertionError((Object)String.format("Setter signature for property %s should either return void or %s or a superclass of %s", property, dc.getCanonicalName(), dc.getCanonicalName()));
            }
            return setter;
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

