/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.enilink.commons.util.Log;
import net.enilink.komma.common.CommonPlugin;
import net.enilink.komma.common.util.DelegatingResourceLocator;
import net.enilink.komma.common.util.ILogger;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.common.util.WrappedException;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractKommaPlugin
extends DelegatingResourceLocator
implements IResourceLocator,
ILogger {
    public static final boolean IS_OSGI_RUNNING;
    public static final boolean IS_RESOURCES_BUNDLE_AVAILABLE;
    protected IResourceLocator[] delegateResourceLocators;

    public AbstractKommaPlugin(IResourceLocator[] delegateResourceLocators) {
        this.delegateResourceLocators = delegateResourceLocators;
    }

    public abstract IResourceLocator getBundleResourceLocator();

    @Override
    protected final IResourceLocator getPrimaryResourceLocator() {
        return this.getBundleResourceLocator();
    }

    @Override
    protected IResourceLocator[] getDelegateResourceLocators() {
        return this.delegateResourceLocators;
    }

    public ILogger getPluginLogger() {
        return (ILogger)((Object)this.getBundleResourceLocator());
    }

    public String getSymbolicName() {
        IResourceLocator resourceLocator = this.getBundleResourceLocator();
        if (resourceLocator instanceof EclipsePlugin) {
            return ((EclipsePlugin)resourceLocator).getSymbolicName();
        }
        String result = this.getClass().getName();
        return result.substring(0, result.lastIndexOf(46));
    }

    @Override
    public void log(Object logEntry) {
        ILogger logger = this.getPluginLogger();
        if (logger == null) {
            if (logEntry instanceof Throwable) {
                ((Throwable)logEntry).printStackTrace(System.err);
            } else {
                System.err.println(logEntry);
            }
        } else {
            logger.log(logEntry);
        }
    }

    public static void main(String[] args) {
        try {
            Manifest manifest;
            String symbolicName;
            String[] relativePath = new String[]{"META-INF", "MANIFEST.MF"};
            Class<AbstractKommaPlugin> theClass = args.length > 0 ? Class.forName(args[0]) : AbstractKommaPlugin.class;
            String className = theClass.getName();
            int index = className.lastIndexOf(".");
            URL classURL = theClass.getResource((index == -1 ? className : className.substring(index + 1)) + ".class");
            URI uri = URIs.createURI((String)classURL.toString());
            int count = 1;
            int i = 0;
            while ((i = className.indexOf(46, i)) != -1) {
                ++count;
                ++i;
            }
            uri = uri.trimSegments(count);
            URL manifestURL = null;
            if (URIs.isArchiveScheme((String)uri.scheme())) {
                try {
                    String manifestURI = uri.appendSegments(relativePath).toString();
                    InputStream inputStream = new URL(manifestURI).openStream();
                    inputStream.close();
                    manifestURL = new URL(manifestURI);
                }
                catch (IOException exception) {
                    uri = URIs.createURI((String)uri.authority()).trimSegments(1);
                }
            }
            if (manifestURL == null) {
                String lastSegment = uri.lastSegment();
                if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                    uri = uri.trimSegments(1);
                }
                uri = uri.appendSegments(relativePath);
                manifestURL = new URL(uri.toString());
            }
            if ((symbolicName = (manifest = new Manifest(manifestURL.openStream())).getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                int end = symbolicName.indexOf(";");
                if (end != -1) {
                    symbolicName = symbolicName.substring(0, end);
                }
                System.out.println("Bundle-SymbolicName=" + symbolicName + " Bundle-Version=" + manifest.getMainAttributes().getValue("Bundle-Version"));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.err.println("No Bundle information found");
    }

    static {
        boolean result = false;
        try {
            result = FrameworkUtil.getBundle(AbstractKommaPlugin.class) != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_OSGI_RUNNING = result;
        result = false;
        if (IS_OSGI_RUNNING) {
            try {
                Bundle resourcesBundle = Stream.of(FrameworkUtil.getBundle(AbstractKommaPlugin.class).getBundleContext().getBundles()).filter(b -> b.getSymbolicName().equals("org.eclipse.core.resources")).findFirst().orElse(null);
                result = resourcesBundle != null && (resourcesBundle.getState() & 0x2C) != 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IS_RESOURCES_BUNDLE_AVAILABLE = result;
    }

    public static class InternalHelper {
        protected InternalPlugin plugin;
        protected Log log;
        protected ResourceBundle resourceBundle;
        protected ResourceBundle untranslatedResourceBundle;

        public InternalHelper(InternalPlugin plugin) {
            this.plugin = plugin;
            this.log = new Log(plugin.getClass());
        }

        protected Bundle getBundle() {
            return this.plugin.getBundle();
        }

        protected Log getLog() {
            return this.log;
        }

        public String getSymbolicName() {
            return this.getBundle().getSymbolicName();
        }

        public URL getBaseURL() {
            return this.getBundle().getEntry("/");
        }

        public Object getImage(String key) throws IOException {
            URL url = new URL(this.getBaseURL() + "icons/" + key + AbstractKommaPlugin.extensionFor(key));
            InputStream inputStream = url.openStream();
            inputStream.close();
            return url;
        }

        public String getString(String key, boolean translate) {
            ResourceBundle bundle;
            ResourceBundle resourceBundle = bundle = translate ? this.resourceBundle : this.untranslatedResourceBundle;
            if (bundle == null) {
                if (translate) {
                    String baseName = (String)this.getBundle().getHeaders().get("Bundle-Localization");
                    if (baseName == null) {
                        baseName = "OSGI-INF/l10n/bundle";
                    }
                    bundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), this.plugin.getClass().getClassLoader());
                } else {
                    String resourceName = this.getBaseURL().toString() + "plugin.properties";
                    try {
                        InputStream inputStream = new URL(resourceName).openStream();
                        bundle = this.untranslatedResourceBundle = new PropertyResourceBundle(inputStream);
                        inputStream.close();
                    }
                    catch (IOException ioException) {
                        throw new MissingResourceException("Missing properties: " + resourceName, this.getClass().getName(), "plugin.properties");
                    }
                }
            }
            return bundle.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return MessageFormat.format(this.getString(key, translate), substitutions);
        }

        public void log(Object logEntry) {
            if (logEntry instanceof IStatus) {
                IStatus status = (IStatus)logEntry;
                this.getLog().log(status);
            } else {
                if (logEntry == null) {
                    logEntry = new RuntimeException(this.getString("_UI_NullLogEntry_exception", true)).fillInStackTrace();
                }
                if (logEntry instanceof Throwable) {
                    Throwable throwable = (Throwable)logEntry;
                    String message = throwable.getLocalizedMessage();
                    if (message == null) {
                        message = "";
                    }
                    this.getLog().log((IStatus)new Status(2, this.getBundle().getSymbolicName(), 0, message, throwable));
                } else {
                    this.getLog().log((IStatus)new Status(2, this.getBundle().getSymbolicName(), 0, logEntry.toString(), null));
                }
            }
        }

        public void logErrorMessage(String message) {
            this.log(new Status(4, this.getBundle().getSymbolicName(), 10001, message, null));
        }

        public void logErrorStatus(String message, IStatus status) {
            if (status == null) {
                this.logErrorMessage(message);
                return;
            }
            MultiStatus multi = new MultiStatus(this.getBundle().getSymbolicName(), 10001, message, null);
            multi.add(status);
            this.log(multi);
        }
    }

    public static abstract class EclipsePlugin
    implements IResourceLocator,
    ILogger,
    InternalPlugin,
    BundleActivator {
        protected InternalHelper helper = new InternalHelper(this);

        @Override
        public String getSymbolicName() {
            return this.helper.getSymbolicName();
        }

        @Override
        public URL getBaseURL() {
            return this.helper.getBaseURL();
        }

        @Override
        public Object getImage(String key) {
            try {
                return this.doGetImage(key);
            }
            catch (MalformedURLException exception) {
                throw new WrappedException(exception);
            }
            catch (IOException exception) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", key), this.getClass().getName(), key);
            }
        }

        protected Object doGetImage(String key) throws IOException {
            return this.helper.getImage(key);
        }

        @Override
        public String getString(String key) {
            return this.helper.getString(key, true);
        }

        @Override
        public String getString(String key, boolean translate) {
            return this.helper.getString(key, translate);
        }

        @Override
        public String getString(String key, Object ... substitutions) {
            return this.helper.getString(key, substitutions, true);
        }

        @Override
        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.helper.getString(key, substitutions, translate);
        }

        @Override
        public void log(Object logEntry) {
            this.helper.log(logEntry);
        }

        @Override
        public Bundle getBundle() {
            return FrameworkUtil.getBundle(this.getClass());
        }

        public void start(BundleContext context) throws Exception {
        }

        public void stop(BundleContext context) throws Exception {
        }
    }

    public static interface InternalPlugin {
        public String getSymbolicName();

        public Bundle getBundle();
    }
}

