/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.adapter;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.enilink.komma.common.adapter.IAdapter;
import net.enilink.komma.common.adapter.IAdapterSet;

public class AdapterSet
extends AbstractSet<IAdapter>
implements IAdapterSet {
    protected final Set<IAdapter> adapters = new HashSet<IAdapter>();
    protected final Object target;

    public AdapterSet(Object target) {
        this.target = target;
    }

    @Override
    public IAdapter getAdapter(Object type) {
        for (IAdapter adapter : this) {
            if (!adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    @Override
    public boolean add(IAdapter e) {
        if (this.adapters.add(e)) {
            e.addTarget(this.target);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.adapters.remove(o)) {
            if (o instanceof IAdapter) {
                ((IAdapter)o).removeTarget(this.target);
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IAdapter> iterator() {
        return new Iterator<IAdapter>(){
            IAdapter current;
            final Iterator<IAdapter> base;
            {
                this.base = AdapterSet.this.adapters.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public IAdapter next() {
                this.current = this.base.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current != null) {
                    this.base.remove();
                    this.current.removeTarget(AdapterSet.this.target);
                }
            }
        };
    }

    @Override
    public int size() {
        return this.adapters.size();
    }
}

