/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.enilink.komma.common.CommonPlugin;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CompositeCommand;
import net.enilink.komma.common.command.ICommand;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public abstract class AbstractCommand
implements ICommand,
IUndoableOperation {
    List<IUndoContext> contexts = new ArrayList<IUndoContext>();
    protected String label;
    protected boolean isPrepared;
    protected boolean isExecutable;
    protected String description;
    private CommandResult commandResult;

    protected AbstractCommand() {
    }

    protected AbstractCommand(String label) {
        this.label = label;
    }

    protected AbstractCommand(String label, String description) {
        this(label);
        this.description = description;
    }

    public void addContext(IUndoContext context) {
        if (!this.contexts.contains(context)) {
            this.contexts.add(context);
        }
    }

    public final IUndoContext[] getContexts() {
        return this.contexts.toArray(new IUndoContext[this.contexts.size()]);
    }

    public final boolean hasContext(IUndoContext context) {
        Assert.isNotNull((Object)context);
        for (int i = 0; i < this.contexts.size(); ++i) {
            IUndoContext otherContext = this.contexts.get(i);
            if (!context.matches(otherContext) && !otherContext.matches(context)) continue;
            return true;
        }
        return false;
    }

    public void removeContext(IUndoContext context) {
        this.contexts.remove(context);
    }

    protected boolean prepare() {
        return false;
    }

    public boolean canExecute() {
        if (!this.isPrepared) {
            this.isExecutable = this.prepare();
            this.isPrepared = true;
        }
        return this.isExecutable;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public IStatus execute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        CommandResult result = this.doExecuteWithResult(monitor, info);
        this.setResult(result);
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected abstract CommandResult doExecuteWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    @Override
    public Collection<?> getAffectedObjects() {
        CommandResult result = this.getCommandResult();
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList objects = new ArrayList();
        for (Object value : result.getReturnValues()) {
            if (value == null) continue;
            objects.add(value);
        }
        return objects;
    }

    @Override
    public Collection<?> getAffectedResources(Object type) {
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return this.description == null ? CommonPlugin.INSTANCE.getString("_UI_AbstractCommand_description") : this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IStatus redo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        CommandResult result = this.doRedoWithResult(monitor, info);
        this.setResult(result);
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected abstract CommandResult doRedoWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public IStatus undo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        CommandResult result = this.doUndoWithResult(monitor, info);
        this.setResult(result);
        return result != null ? result.getStatus() : Status.OK_STATUS;
    }

    protected abstract CommandResult doUndoWithResult(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    @Override
    public ICommand compose(IUndoableOperation operation) {
        CompositeCommand result = new CompositeCommand();
        result.add(this);
        result.add(operation);
        return result;
    }

    @Override
    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    protected final void setResult(CommandResult result) {
        this.commandResult = result;
    }

    public String getLabel() {
        return this.label != null ? this.label : CommonPlugin.INSTANCE.getString("_UI_AbstractCommand_label");
    }

    @Override
    public void setLabel(String name) {
        this.label = name;
    }

    public void dispose() {
    }

    public String toString() {
        String className = this.getClass().getName();
        int lastDotIndex = className.lastIndexOf(46);
        StringBuffer result = new StringBuffer(lastDotIndex == -1 ? className : className.substring(lastDotIndex + 1));
        result.append(" (label: " + this.getLabel() + ")");
        result.append(" (description: " + this.description + ")");
        result.append(" (isPrepared: " + this.isPrepared + ")");
        result.append(" (isExecutable: " + this.isExecutable + ")");
        return result.toString();
    }

    @Override
    public ICommand reduce() {
        return this;
    }

    public static interface INoChangeRecording {
    }

    public static interface INonDirtying {
    }
}

