/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.command;

import java.util.Collection;
import java.util.Collections;
import net.enilink.komma.common.CommonPlugin;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommandWrapper
extends AbstractCommand {
    protected ICommand command;

    public CommandWrapper(ICommand command) {
        super(command.getLabel(), command.getDescription());
        this.command = command;
    }

    protected CommandWrapper(String label, ICommand command) {
        super(label, command.getDescription());
        this.command = command;
    }

    public CommandWrapper(String label, String description, ICommand command) {
        super(label, description);
        this.command = command;
    }

    protected CommandWrapper() {
    }

    protected CommandWrapper(String label) {
        super(label);
    }

    protected CommandWrapper(String label, String description) {
        super(label, description);
    }

    public ICommand getCommand() {
        return this.command;
    }

    protected ICommand createCommand() {
        return null;
    }

    @Override
    protected boolean prepare() {
        if (this.command == null) {
            this.command = this.createCommand();
        }
        boolean result = this.command.canExecute();
        return result;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.execute(progressMonitor, info);
            return this.command.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    public boolean canUndo() {
        return this.command == null || this.command.canUndo();
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.undo(progressMonitor, info);
            return this.command.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.redo(progressMonitor, info);
            return this.command.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    public Collection<?> getAffectedObjects() {
        return this.command == null ? Collections.EMPTY_LIST : this.command.getAffectedObjects();
    }

    @Override
    public String getLabel() {
        return this.command == null ? super.getLabel() : this.command.getLabel();
    }

    @Override
    public String getDescription() {
        return this.description == null ? (this.command == null ? CommonPlugin.INSTANCE.getString("_UI_CommandWrapper_description") : this.command.getDescription()) : this.description;
    }

    @Override
    public void dispose() {
        if (this.command != null) {
            this.command.dispose();
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (command: " + this.command + ")");
        return result.toString();
    }
}

