/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.enilink.commons.util.Log;
import net.enilink.komma.common.CommonPlugin;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.ICompositeCommand;
import net.enilink.komma.common.util.WrappedException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class CompositeCommand
extends AbstractCommand
implements ICompositeCommand {
    static Log log = new Log(CompositeCommand.class);
    private final List<IUndoableOperation> children;
    private boolean executed;

    public static ICommand compose(ICommand command, ICommand next) {
        if (command == null) {
            return next;
        }
        if (next != null) {
            return command.compose(next);
        }
        return command;
    }

    public CompositeCommand() {
        this(null);
    }

    public CompositeCommand(String label) {
        this(label, (List<? extends IUndoableOperation>)null);
    }

    public CompositeCommand(String label, List<? extends IUndoableOperation> children) {
        this(label, null, children);
    }

    public CompositeCommand(String label, String description, List<? extends IUndoableOperation> children) {
        super(label, description);
        this.children = children != null ? new ArrayList<IUndoableOperation>(children) : new ArrayList<IUndoableOperation>(4);
    }

    @Override
    public void add(IUndoableOperation operation) {
        this.assertNotExecuted();
        if (!this.getChildren().contains(operation)) {
            this.getChildren().add(operation);
            this.didAdd(operation);
        }
    }

    protected IStatus aggregateStatuses(List<IStatus> statuses) {
        IStatus result;
        if (statuses.isEmpty()) {
            result = Status.OK_STATUS;
        } else if (statuses.size() == 1) {
            result = statuses.get(0);
        } else {
            IStatus[] statusArray = statuses.toArray(new IStatus[statuses.size()]);
            IStatus worst = statusArray[0];
            for (int i = 1; i < statusArray.length; ++i) {
                if (statusArray[i].getSeverity() <= worst.getSeverity()) continue;
                worst = statusArray[i];
            }
            result = new MultiStatus(worst.getPlugin(), worst.getCode(), statusArray, worst.getMessage(), null);
        }
        return result;
    }

    private boolean anyChildHasContext(IUndoContext ctx) {
        boolean result = false;
        Iterator<IUndoableOperation> iter = this.iterator();
        while (!result && iter.hasNext()) {
            result = iter.next().hasContext(ctx);
        }
        return result;
    }

    public IStatus addAndExecute(ICommand command, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.CANCEL_STATUS;
        if (command != null) {
            if (!this.isPrepared) {
                if (this.getChildren().isEmpty()) {
                    this.isPrepared = true;
                    this.isExecutable = true;
                } else {
                    this.isExecutable = this.prepare();
                    this.isPrepared = true;
                    if (this.isExecutable && !(status = this.execute(monitor, info)).isOK()) {
                        return status;
                    }
                }
            }
            if (command.canExecute()) {
                try {
                    status = command.execute(monitor, info);
                    this.getChildren().add(command);
                    if (status.isOK()) {
                        for (IUndoContext context : command.getContexts()) {
                            this.addContext(context);
                        }
                    }
                    return status;
                }
                catch (RuntimeException exception) {
                    CommonPlugin.INSTANCE.log(new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), exception).fillInStackTrace());
                }
            }
            command.dispose();
        }
        return status;
    }

    public boolean appendIfCanExecute(ICommand command) {
        if (command == null) {
            return false;
        }
        if (command.canExecute()) {
            this.getChildren().add(command);
            for (IUndoContext context : command.getContexts()) {
                this.addContext(context);
            }
            return true;
        }
        command.dispose();
        return false;
    }

    protected final void assertNotExecuted() {
        if (this.isExecuted()) {
            IllegalStateException exc = new IllegalStateException("Operation already executed");
            throw exc;
        }
    }

    @Override
    public boolean canRedo() {
        boolean result = !this.isEmpty() && super.canRedo();
        Iterator<IUndoableOperation> iter = this.iterator();
        while (result && iter.hasNext()) {
            result = iter.next().canRedo();
        }
        return result;
    }

    @Override
    public boolean canUndo() {
        boolean result = !this.isEmpty() && super.canUndo();
        Iterator<IUndoableOperation> iter = this.iterator();
        while (result && iter.hasNext()) {
            result = iter.next().canUndo();
        }
        return result;
    }

    @Override
    public final ICommand compose(IUndoableOperation operation) {
        if (operation != null) {
            this.add(operation);
        }
        return this;
    }

    private void didAdd(IUndoableOperation operation) {
        IUndoContext[] childContexts = operation.getContexts();
        for (int i = 0; i < childContexts.length; ++i) {
            if (this.hasContext(childContexts[i])) continue;
            this.addContext(childContexts[i]);
        }
    }

    private void didRemove(IUndoableOperation operation) {
        IUndoContext[] childContexts = operation.getContexts();
        for (int i = 0; i < childContexts.length; ++i) {
            if (this.anyChildHasContext(childContexts[i])) continue;
            this.removeContext(childContexts[i]);
        }
    }

    @Override
    public void dispose() {
        for (IUndoableOperation nextOperation : this) {
            nextOperation.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator<IUndoableOperation> iter = this.listIterator();
            while (iter.hasNext()) {
                IUndoableOperation next = iter.next();
                try {
                    IStatus status = next.execute((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        log.trace("Composite operation execution recovery: child command status is CANCEL or ERROR.");
                        iter.previous();
                        this.unwindFailedExecute(iter, info);
                        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                    }
                    if (progressMonitor.isCanceled()) {
                        log.trace("Composite operation redo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedExecute(iter, info);
                        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                    }
                    progressMonitor.worked(1);
                    this.executed = true;
                }
                catch (ExecutionException e) {
                    iter.previous();
                    this.unwindFailedExecute(iter, info);
                    throw e;
                    return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator<IUndoableOperation> iter = this.listIterator();
            while (iter.hasNext()) {
                IUndoableOperation next = iter.next();
                try {
                    IStatus status = next.redo((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        log.trace("Composite operation redo recovery: child command status is CANCEL or ERROR.");
                        iter.previous();
                        this.unwindFailedRedo(iter, info);
                        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                    }
                    if (progressMonitor.isCanceled()) {
                        log.trace("Composite operation redo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedRedo(iter, info);
                        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                    }
                    progressMonitor.worked(1);
                    this.executed = true;
                }
                catch (ExecutionException e) {
                    iter.previous();
                    this.unwindFailedRedo(iter, info);
                    throw e;
                    return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator<IUndoableOperation> iter = this.listIterator(this.size());
            while (iter.hasPrevious()) {
                IUndoableOperation prev = iter.previous();
                try {
                    IStatus status = prev.undo((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        log.trace("Composite operation undo recovery: child command status is CANCEL or ERROR.");
                        iter.next();
                        this.unwindFailedUndo(iter, info);
                        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                    }
                    if (progressMonitor.isCanceled()) {
                        log.trace("Composite operation undo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedUndo(iter, info);
                        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                    }
                    progressMonitor.worked(1);
                    this.executed = true;
                }
                catch (ExecutionException e) {
                    iter.next();
                    this.unwindFailedUndo(iter, info);
                    throw e;
                    return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    @Override
    public Collection<?> getAffectedObjects() {
        ArrayList result = new ArrayList();
        for (IUndoableOperation command : this.getChildren()) {
            if (!(command instanceof ICommand)) continue;
            result.addAll(((ICommand)command).getAffectedObjects());
        }
        return result;
    }

    public Collection<Object> getAffectedResources(Object type) {
        HashSet result = new HashSet();
        for (IUndoableOperation nextOperation : this) {
            Collection<?> nextAffected;
            if (!(nextOperation instanceof ICommand) || (nextAffected = ((ICommand)nextOperation).getAffectedResources(type)) == null) continue;
            result.addAll(nextAffected);
        }
        return new ArrayList<Object>(result);
    }

    protected List<IUndoableOperation> getChildren() {
        return this.children;
    }

    @Override
    public CommandResult getCommandResult() {
        CommandResult commandResult = super.getCommandResult();
        if (commandResult == null) {
            ArrayList<IStatus> statusList = new ArrayList<IStatus>(this.size());
            for (IUndoableOperation operation : this) {
                ICommand command;
                CommandResult result;
                if (!(operation instanceof ICommand) || (result = (command = (ICommand)operation).getCommandResult()) == null) continue;
                statusList.add(result.getStatus());
            }
            return new CommandResult(this.aggregateStatuses(statusList), this.getReturnValues());
        }
        return commandResult;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (!this.getChildren().isEmpty()) {
            for (IUndoableOperation child : this.getChildren()) {
                String childLabel = child.getLabel();
                if (childLabel == null) continue;
                return childLabel;
            }
        }
        return super.getLabel();
    }

    protected Object getReturnValues() {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (IUndoableOperation operation : this) {
            Object returnValue;
            ICommand command;
            CommandResult result;
            if (!(operation instanceof ICommand) || (result = (command = (ICommand)operation).getCommandResult()) == null || (returnValue = result.getReturnValue()) == null) continue;
            if (command instanceof ICompositeCommand) {
                if (returnValue != null && returnValue instanceof Collection) {
                    returnValues.addAll((Collection)returnValue);
                    continue;
                }
                returnValues.add(returnValue);
                continue;
            }
            returnValues.add(returnValue);
        }
        return returnValues;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() < 1;
    }

    protected final boolean isExecuted() {
        return this.executed;
    }

    @Override
    public Iterator<IUndoableOperation> iterator() {
        return new ChildIterator();
    }

    @Override
    public ListIterator<IUndoableOperation> listIterator() {
        return new ChildListIterator(0);
    }

    @Override
    public ListIterator<IUndoableOperation> listIterator(int index) {
        return new ChildListIterator(index);
    }

    @Override
    protected boolean prepare() {
        boolean canExecute = !this.isEmpty();
        Iterator<IUndoableOperation> iter = this.iterator();
        while (canExecute && iter.hasNext()) {
            canExecute = iter.next().canExecute();
        }
        return canExecute;
    }

    @Override
    public ICommand reduce() {
        switch (this.size()) {
            case 1: {
                IUndoableOperation child = this.iterator().next();
                if (!(child instanceof ICommand)) break;
                ICommand cmd = ((ICommand)child).reduce();
                if (this.getLabel() != null && this.getLabel().length() > 0) {
                    cmd.setLabel(this.getLabel());
                }
                return cmd;
            }
        }
        return this;
    }

    @Override
    public void remove(IUndoableOperation operation) {
        this.assertNotExecuted();
        if (this.getChildren().remove(operation)) {
            this.didRemove(operation);
        }
    }

    @Override
    public int size() {
        return this.getChildren().size();
    }

    private void unwindFailedExecute(ListIterator<IUndoableOperation> iter, IAdaptable info) {
        while (iter.hasPrevious()) {
            IUndoableOperation prev = iter.previous();
            if (!prev.canUndo()) {
                log.log((IStatus)new Status(4, "net.enilink.komma.common", 20, CommonPlugin.INSTANCE.getString("Command_executeRecoveryFailed", CommonPlugin.INSTANCE.getString("Command_cannotUndoExecuted")), null));
                break;
            }
            try {
                prev.undo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                log.log((IStatus)new Status(4, "net.enilink.komma.common", 20, CommonPlugin.INSTANCE.getString("Command_executeRecoveryFailed", inner.getLocalizedMessage()), (Throwable)inner));
                break;
            }
        }
    }

    private void unwindFailedRedo(ListIterator<IUndoableOperation> iter, IAdaptable info) {
        while (iter.hasPrevious()) {
            IUndoableOperation prev = iter.previous();
            if (!prev.canUndo()) {
                log.log((IStatus)new Status(4, "net.enilink.komma.common", 22, CommonPlugin.INSTANCE.getString("Command_redoRecoveryFailed", CommonPlugin.INSTANCE.getString("Command_cannotUndo")), null));
                break;
            }
            try {
                prev.undo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                log.log((IStatus)new Status(4, "net.enilink.komma.common", 22, CommonPlugin.INSTANCE.getString("Command_redoRecoveryFailed", inner.getLocalizedMessage()), (Throwable)inner));
                break;
            }
        }
    }

    private void unwindFailedUndo(ListIterator<IUndoableOperation> iter, IAdaptable info) {
        while (iter.hasNext()) {
            IUndoableOperation next = iter.next();
            if (!next.canRedo()) {
                log.log((IStatus)new Status(4, "net.enilink.komma.common", 21, CommonPlugin.INSTANCE.getString("Command_undoRecoveryFailed", CommonPlugin.INSTANCE.getString("Command_cannotRedo")), null));
                break;
            }
            try {
                next.redo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                log.log((IStatus)new Status(4, "net.enilink.komma.common", 21, CommonPlugin.INSTANCE.getString("Command_undoRecoveryFailed", inner.getLocalizedMessage()), (Throwable)inner));
                break;
            }
        }
    }

    private class ChildListIterator
    extends ChildIterator
    implements ListIterator<IUndoableOperation> {
        ChildListIterator(int index) {
            super(index);
        }

        @Override
        public void add(IUndoableOperation o) {
            CompositeCommand.this.assertNotExecuted();
            if (!CompositeCommand.this.getChildren().contains(o)) {
                this.iter.add(o);
                CompositeCommand.this.didAdd(o);
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public IUndoableOperation previous() {
            this.last = (IUndoableOperation)this.iter.previous();
            return this.last;
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void set(IUndoableOperation o) {
            CompositeCommand.this.assertNotExecuted();
            if (!CompositeCommand.this.getChildren().contains(o)) {
                CompositeCommand.this.didRemove(this.last);
                this.iter.set(o);
                this.last = o;
                CompositeCommand.this.didAdd(o);
            }
        }
    }

    private class ChildIterator
    implements Iterator<IUndoableOperation> {
        protected final ListIterator<IUndoableOperation> iter;
        protected IUndoableOperation last;

        ChildIterator() {
            this(0);
        }

        ChildIterator(int index) {
            this.iter = CompositeCommand.this.getChildren().listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public IUndoableOperation next() {
            this.last = this.iter.next();
            return this.last;
        }

        @Override
        public void remove() {
            CompositeCommand.this.assertNotExecuted();
            this.iter.remove();
            CompositeCommand.this.didRemove(this.last);
            this.last = null;
        }
    }
}

