/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.enilink.komma.common.CommonPlugin;
import net.enilink.komma.common.command.CompositeCommand;
import net.enilink.komma.common.command.ICommand;
import org.eclipse.core.commands.operations.IUndoableOperation;

public class ExtendedCompositeCommand
extends CompositeCommand {
    public static final int LAST_COMMAND_ALL = Integer.MIN_VALUE;
    public static final int MERGE_COMMAND_ALL = Integer.MAX_VALUE;
    protected int resultIndex = Integer.MAX_VALUE;

    public ExtendedCompositeCommand() {
    }

    public ExtendedCompositeCommand(String label) {
        super(label);
    }

    public ExtendedCompositeCommand(String label, String description) {
        super(label, description, null);
    }

    public ExtendedCompositeCommand(String label, List<ICommand> commandList) {
        super(label, commandList);
    }

    public ExtendedCompositeCommand(String label, String description, List<ICommand> commandList) {
        super(label, description, commandList);
    }

    public ExtendedCompositeCommand(int resultIndex) {
        this.resultIndex = resultIndex;
    }

    public ExtendedCompositeCommand(int resultIndex, String label) {
        super(label);
        this.resultIndex = resultIndex;
    }

    public ExtendedCompositeCommand(int resultIndex, String label, String description) {
        super(label, description, null);
        this.resultIndex = resultIndex;
    }

    public ExtendedCompositeCommand(int resultIndex, List<ICommand> commandList) {
        this.resultIndex = resultIndex;
        this.getChildren().addAll(commandList);
    }

    public ExtendedCompositeCommand(int resultIndex, String label, List<ICommand> commandList) {
        super(label, null, commandList);
        this.resultIndex = resultIndex;
    }

    public ExtendedCompositeCommand(int resultIndex, String label, String description, List<ICommand> commandList) {
        super(label, description, commandList);
        this.resultIndex = resultIndex;
    }

    public List<? extends ICommand> getCommandList() {
        return Collections.unmodifiableList(this.getChildren());
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        List<IUndoableOperation> children = this.getChildren();
        if (this.getChildren().isEmpty()) {
            return CommonPlugin.INSTANCE.getString("_UI_AbstractCommand_label");
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return children.get(children.size() - 1).getLabel();
        }
        if (this.resultIndex < children.size()) {
            return children.get(this.resultIndex).getLabel();
        }
        return super.getLabel();
    }

    @Override
    protected Object getReturnValues() {
        if (this.getChildren().isEmpty()) {
            return null;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            IUndoableOperation command = this.getChildren().get(this.getChildren().size() - 1);
            if (command instanceof ICommand) {
                return ((ICommand)command).getCommandResult().getReturnValue();
            }
        } else {
            IUndoableOperation command;
            if (this.resultIndex == Integer.MAX_VALUE) {
                return super.getReturnValues();
            }
            if (this.resultIndex < this.getChildren().size() && (command = this.getChildren().get(this.resultIndex)) instanceof ICommand) {
                return ((ICommand)command).getCommandResult().getReturnValue();
            }
        }
        return null;
    }

    @Override
    public Collection<?> getAffectedObjects() {
        if (this.getChildren().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((ICommand)this.getChildren().get(this.getChildren().size() - 1)).getAffectedObjects();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return super.getAffectedObjects();
        }
        if (this.resultIndex < this.getChildren().size()) {
            return ((ICommand)this.getChildren().get(this.resultIndex)).getAffectedObjects();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (commandList: #" + this.getChildren().size() + ")");
        result.append(" (resultIndex: " + this.resultIndex + ")");
        return result.toString();
    }
}

