/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.common.notify;

import net.enilink.komma.common.notify.INotification;

public abstract class NotificationFilter<T extends INotification> {
    private static final NotificationFilter<?> anyFilter = new NotificationFilter<INotification>(){

        @Override
        public final boolean accept(INotification n) {
            return true;
        }

        @Override
        public NotificationFilter<INotification> and(NotificationFilter<? super INotification> other) {
            return other;
        }

        @Override
        public NotificationFilter<INotification> or(NotificationFilter<? super INotification> other) {
            return this;
        }
    };

    public abstract boolean accept(T var1);

    public static NotificationFilter<INotification> instanceOf(final Class<? extends INotification> clazz) {
        return new NotificationFilter<INotification>(){

            @Override
            public boolean accept(INotification x) {
                return clazz.isAssignableFrom(x.getClass());
            }
        };
    }

    public NotificationFilter<T> and(final NotificationFilter<? super T> other) {
        return other == NotificationFilter.any() ? this : new NotificationFilter<T>(){

            @Override
            public boolean accept(T x) {
                return NotificationFilter.this.accept(x) && other.accept(x);
            }
        };
    }

    public NotificationFilter<T> or(final NotificationFilter<? super T> other) {
        return other == NotificationFilter.any() ? other : new NotificationFilter<T>(){

            @Override
            public boolean accept(T x) {
                return NotificationFilter.this.accept(x) || other.accept(x);
            }
        };
    }

    public NotificationFilter<T> negated() {
        return new NotificationFilter<T>(){

            @Override
            public boolean accept(T notification) {
                return !NotificationFilter.this.accept(notification);
            }
        };
    }

    public static <T extends INotification> NotificationFilter<T> any() {
        return anyFilter;
    }
}

