/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.parboiled.BaseParser;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.support.Var;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.Types;

class RuleMethod
extends MethodNode {
    private final List<InstructionGroup> groups = new ArrayList<InstructionGroup>();
    private final List<LabelNode> usedLabels = new ArrayList<LabelNode>();
    private final Class<?> ownerClass;
    private int parameterCount;
    private boolean containsImplicitActions;
    private boolean containsExplicitActions;
    private boolean containsVars;
    private boolean containsPotentialSuperCalls;
    private boolean hasDontExtend;
    private boolean hasExplicitActionOnlyAnnotation;
    private boolean hasCachedAnnotation;
    private boolean hasDontLabelAnnotation;
    private boolean hasSuppressNodeAnnotation;
    private boolean hasSuppressSubnodesAnnotation;
    private boolean hasSkipNodeAnnotation;
    private boolean hasMemoMismatchesAnnotation;
    private boolean hasSkipActionsInPredicatesAnnotation;
    private int numberOfReturns;
    private InstructionGraphNode returnInstructionNode;
    private List<InstructionGraphNode> graphNodes;
    private List<LocalVariableNode> localVarVariables;
    private boolean bodyRewritten;
    private boolean skipGeneration;

    public RuleMethod(Class<?> clazz, int n, String string, String string2, String string3, String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        super(458752, n, string, string2, string3, stringArray);
        this.ownerClass = clazz;
        this.parameterCount = Type.getArgumentTypes((String)string2).length;
        this.hasCachedAnnotation = this.parameterCount == 0;
        this.hasDontLabelAnnotation = bl2;
        this.hasExplicitActionOnlyAnnotation = bl;
        this.hasSkipActionsInPredicatesAnnotation = bl3;
        this.skipGeneration = this.isSuperMethod();
    }

    public List<InstructionGroup> getGroups() {
        return this.groups;
    }

    public List<LabelNode> getUsedLabels() {
        return this.usedLabels;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public boolean hasDontExtend() {
        return this.hasDontExtend;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean containsImplicitActions() {
        return this.containsImplicitActions;
    }

    public void setContainsImplicitActions(boolean bl) {
        this.containsImplicitActions = bl;
    }

    public boolean containsExplicitActions() {
        return this.containsExplicitActions;
    }

    public void setContainsExplicitActions(boolean bl) {
        this.containsExplicitActions = bl;
    }

    public boolean containsVars() {
        return this.containsVars;
    }

    public boolean containsPotentialSuperCalls() {
        return this.containsPotentialSuperCalls;
    }

    public boolean hasCachedAnnotation() {
        return this.hasCachedAnnotation;
    }

    public boolean hasDontLabelAnnotation() {
        return this.hasDontLabelAnnotation;
    }

    public boolean hasSuppressNodeAnnotation() {
        return this.hasSuppressNodeAnnotation;
    }

    public boolean hasSuppressSubnodesAnnotation() {
        return this.hasSuppressSubnodesAnnotation;
    }

    public boolean hasSkipActionsInPredicatesAnnotation() {
        return this.hasSkipActionsInPredicatesAnnotation;
    }

    public boolean hasSkipNodeAnnotation() {
        return this.hasSkipNodeAnnotation;
    }

    public boolean hasMemoMismatchesAnnotation() {
        return this.hasMemoMismatchesAnnotation;
    }

    public int getNumberOfReturns() {
        return this.numberOfReturns;
    }

    public InstructionGraphNode getReturnInstructionNode() {
        return this.returnInstructionNode;
    }

    public void setReturnInstructionNode(InstructionGraphNode instructionGraphNode) {
        this.returnInstructionNode = instructionGraphNode;
    }

    public List<InstructionGraphNode> getGraphNodes() {
        return this.graphNodes;
    }

    public List<LocalVariableNode> getLocalVarVariables() {
        return this.localVarVariables;
    }

    public boolean isBodyRewritten() {
        return this.bodyRewritten;
    }

    public void setBodyRewritten() {
        this.bodyRewritten = true;
    }

    public boolean isSuperMethod() {
        Preconditions.checkState(StringUtils.isNotEmpty(this.name));
        return this.name.charAt(0) == '$';
    }

    public InstructionGraphNode setGraphNode(AbstractInsnNode abstractInsnNode, BasicValue basicValue, List<BasicValue> list) {
        int n;
        InstructionGraphNode instructionGraphNode;
        if (this.graphNodes == null) {
            this.graphNodes = new ArrayList<InstructionGraphNode>(Arrays.asList(new InstructionGraphNode[this.instructions.size()]));
        }
        if ((instructionGraphNode = this.graphNodes.get(n = this.instructions.indexOf(abstractInsnNode))) == null) {
            instructionGraphNode = new InstructionGraphNode(abstractInsnNode, basicValue);
            this.graphNodes.set(n, instructionGraphNode);
        }
        instructionGraphNode.addPredecessors(list);
        return instructionGraphNode;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (Types.EXPLICIT_ACTIONS_ONLY_DESC.equals(string)) {
            this.hasExplicitActionOnlyAnnotation = true;
            return null;
        }
        if (Types.CACHED_DESC.equals(string)) {
            this.hasCachedAnnotation = true;
            return null;
        }
        if (Types.SUPPRESS_NODE_DESC.equals(string)) {
            this.hasSuppressNodeAnnotation = true;
            return null;
        }
        if (Types.SUPPRESS_SUBNODES_DESC.equals(string)) {
            this.hasSuppressSubnodesAnnotation = true;
            return null;
        }
        if (Types.SKIP_NODE_DESC.equals(string)) {
            this.hasSkipNodeAnnotation = true;
            return null;
        }
        if (Types.MEMO_MISMATCHES_DESC.equals(string)) {
            this.hasMemoMismatchesAnnotation = true;
            return null;
        }
        if (Types.SKIP_ACTIONS_IN_PREDICATES_DESC.equals(string)) {
            this.hasSkipActionsInPredicatesAnnotation = true;
            return null;
        }
        if (Types.DONT_SKIP_ACTIONS_IN_PREDICATES_DESC.equals(string)) {
            this.hasSkipActionsInPredicatesAnnotation = false;
            return null;
        }
        if (Types.DONT_LABEL_DESC.equals(string)) {
            this.hasDontLabelAnnotation = true;
            return null;
        }
        if (Types.DONT_EXTEND_DESC.equals(string)) {
            this.hasDontExtend = true;
            return null;
        }
        return bl ? super.visitAnnotation(string, true) : null;
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.applyExplicitAction(n, string, string2, string3);
        super.visitMethodInsn(n, string, string2, string3);
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        this.applyExplicitAction(n, string, string2, string3);
        super.visitMethodInsn(n, string, string2, string3, bl);
    }

    private void applyExplicitAction(int n, String string, String string2, String string3) {
        switch (n) {
            case 184: {
                if (!this.hasExplicitActionOnlyAnnotation && AsmUtils.isBooleanValueOfZ(string, string2, string3)) {
                    this.containsImplicitActions = true;
                    break;
                }
                if (!AsmUtils.isActionRoot(string, string2)) break;
                this.containsExplicitActions = true;
                break;
            }
            case 183: {
                if ("<init>".equals(string2)) {
                    if (!AsmUtils.isVarRoot(string, string2, string3)) break;
                    this.containsVars = true;
                    break;
                }
                if (!AsmUtils.isAssignableTo(string, BaseParser.class)) break;
                this.containsPotentialSuperCalls = true;
            }
        }
    }

    public void visitInsn(int n) {
        if (n == 176) {
            ++this.numberOfReturns;
        }
        super.visitInsn(n);
    }

    public void visitJumpInsn(int n, Label label) {
        this.usedLabels.add(this.getLabelNode(label));
        super.visitJumpInsn(n, label);
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.usedLabels.add(this.getLabelNode(label));
        for (Label label2 : labelArray) {
            this.usedLabels.add(this.getLabelNode(label2));
        }
        super.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.usedLabels.add(this.getLabelNode(label));
        for (Label label2 : labelArray) {
            this.usedLabels.add(this.getLabelNode(label2));
        }
        super.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    public void visitLineNumber(int n, Label label) {
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        if (n > this.parameterCount && Var.class.isAssignableFrom(AsmUtils.getClassForType(Type.getType((String)string2)))) {
            if (this.localVarVariables == null) {
                this.localVarVariables = new ArrayList<LocalVariableNode>();
            }
            this.localVarVariables.add(new LocalVariableNode(string, string2, null, null, null, n));
        }
    }

    public String toString() {
        return this.name;
    }

    public void moveFlagsTo(RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(ruleMethod, "overridingMethod");
        ruleMethod.hasCachedAnnotation |= this.hasCachedAnnotation;
        ruleMethod.hasDontLabelAnnotation |= this.hasDontLabelAnnotation;
        ruleMethod.hasSuppressNodeAnnotation |= this.hasSuppressNodeAnnotation;
        ruleMethod.hasSuppressSubnodesAnnotation |= this.hasSuppressSubnodesAnnotation;
        ruleMethod.hasSkipNodeAnnotation |= this.hasSkipNodeAnnotation;
        ruleMethod.hasMemoMismatchesAnnotation |= this.hasMemoMismatchesAnnotation;
        this.hasCachedAnnotation = false;
        this.hasDontLabelAnnotation = true;
        this.hasSuppressNodeAnnotation = false;
        this.hasSuppressSubnodesAnnotation = false;
        this.hasSkipNodeAnnotation = false;
        this.hasMemoMismatchesAnnotation = false;
    }

    public boolean isGenerationSkipped() {
        return this.skipGeneration;
    }

    public void dontSkipGeneration() {
        this.skipGeneration = false;
    }

    public void suppressNode() {
        this.hasSuppressNodeAnnotation = true;
    }
}

