/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.properties.exceptions.ObjectConversionException;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;
import net.enilink.komma.literals.internal.BigDecimalConverter;
import net.enilink.komma.literals.internal.BigIntegerConverter;
import net.enilink.komma.literals.internal.BooleanConverter;
import net.enilink.komma.literals.internal.ByteConverter;
import net.enilink.komma.literals.internal.CharacterConverter;
import net.enilink.komma.literals.internal.ClassConverter;
import net.enilink.komma.literals.internal.DateConverter;
import net.enilink.komma.literals.internal.DoubleConverter;
import net.enilink.komma.literals.internal.DurationConverter;
import net.enilink.komma.literals.internal.FloatConverter;
import net.enilink.komma.literals.internal.GregorianCalendarConverter;
import net.enilink.komma.literals.internal.IntegerConverter;
import net.enilink.komma.literals.internal.LocaleConverter;
import net.enilink.komma.literals.internal.LongConverter;
import net.enilink.komma.literals.internal.ObjectConstructorConverter;
import net.enilink.komma.literals.internal.ObjectSerializationConverter;
import net.enilink.komma.literals.internal.PatternConverter;
import net.enilink.komma.literals.internal.QNameConverter;
import net.enilink.komma.literals.internal.ShortConverter;
import net.enilink.komma.literals.internal.SqlDateConverter;
import net.enilink.komma.literals.internal.SqlTimeConverter;
import net.enilink.komma.literals.internal.SqlTimestampConverter;
import net.enilink.komma.literals.internal.StringConverter;
import net.enilink.komma.literals.internal.ValueOfConverter;
import net.enilink.komma.literals.internal.XMLGregorianCalendarConverter;
import net.enilink.vocab.rdf.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralConverter
implements Cloneable {
    private static final String DATATYPES_PROPERTIES = "META-INF/net.enilink.komma.datatypes";
    private static final String JAVA_SCHEME = "java";
    private ClassLoader cl;
    private ConcurrentMap<String, IConverter<?>> converters = new ConcurrentHashMap();
    Injector injector;
    private ConcurrentMap<URI, Class<?>> javaClasses = new ConcurrentHashMap();
    @Inject
    private ILiteralFactory literalFactory;
    private final Logger logger = LoggerFactory.getLogger(LiteralConverter.class);
    private ConcurrentMap<Class<?>, URI> rdfTypes = new ConcurrentHashMap();

    public void addDatatype(Class<?> javaClass, URI datatype) {
        this.recordType(javaClass, datatype);
    }

    public LiteralConverter clone() {
        try {
            LiteralConverter cloned = (LiteralConverter)super.clone();
            cloned.javaClasses = new ConcurrentHashMap(this.javaClasses);
            cloned.converters = new ConcurrentHashMap(this.converters);
            cloned.rdfTypes = new ConcurrentHashMap(this.rdfTypes);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ILiteral createLiteral(Object object, URI datatype) {
        if (object instanceof String) {
            return this.literalFactory.createLiteral((String)object, datatype, null);
        }
        IConverter<?> converter = null;
        converter = null != datatype ? this.findConverter(datatype) : this.findConverter(object.getClass());
        return converter.serialize(object);
    }

    public Object createObject(ILiteral literal) {
        URI datatype = literal.getDatatype();
        if (datatype == null) {
            return literal.getLabel();
        }
        IConverter<?> converter = this.findConverter(datatype);
        try {
            return converter.deserialize(literal.getLabel());
        }
        catch (Exception e) {
            this.logger.warn("Conversion of literal " + literal + " failed.", (Throwable)e);
            return literal;
        }
    }

    public Class<?> findClass(URI datatype) {
        if (this.javaClasses.containsKey(datatype)) {
            return (Class)this.javaClasses.get(datatype);
        }
        try {
            if (datatype.scheme().equals(JAVA_SCHEME)) {
                return Class.forName(datatype.localPart(), true, this.cl);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ObjectConversionException((Throwable)e);
        }
        return null;
    }

    private <T> IConverter<T> findConverter(Class<T> type) {
        IConverter<T> converter;
        String name;
        block7: {
            name = type.getName();
            if (this.converters.containsKey(name)) {
                return (IConverter)this.converters.get(name);
            }
            try {
                converter = new ValueOfConverter<T>(type);
            }
            catch (NoSuchMethodException e1) {
                try {
                    converter = new ObjectConstructorConverter<T>(type);
                }
                catch (NoSuchMethodException e2) {
                    if (Serializable.class.isAssignableFrom(type)) {
                        converter = new ObjectSerializationConverter<T>(type);
                        break block7;
                    }
                    throw new ObjectConversionException((Throwable)e1);
                }
            }
        }
        this.injector.injectMembers(converter);
        IConverter o = this.converters.putIfAbsent(name, converter);
        if (o != null) {
            converter = o;
        }
        return converter;
    }

    private IConverter<?> findConverter(URI datatype) {
        Class<?> type;
        if (this.javaClasses.containsKey(datatype)) {
            type = (Class<?>)this.javaClasses.get(datatype);
        } else if (datatype.scheme().equals(JAVA_SCHEME)) {
            try {
                type = Class.forName(datatype.localPart(), true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectConversionException((Throwable)e);
            }
        } else {
            throw new ObjectConversionException("Unknown datatype: " + datatype);
        }
        return this.findConverter(type);
    }

    public URI findDatatype(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        if (this.rdfTypes.containsKey(type)) {
            return (URI)this.rdfTypes.get(type);
        }
        URI datatype = URIs.createURI((String)("java:" + type.getName()));
        this.recordType(type, datatype);
        return datatype;
    }

    public boolean isDatatype(Class<?> type) {
        return this.rdfTypes.containsKey(type) || null != this.findConverter(type);
    }

    private void loadDatatypes(ClassLoader cl, String properties) throws IOException, ClassNotFoundException {
        if (cl == null) {
            return;
        }
        Enumeration<URL> resources = cl.getResources(properties);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Properties p = new Properties();
                p.load(url.openStream());
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    String className = (String)e.getKey();
                    String types = (String)e.getValue();
                    Class<?> lc = Class.forName(className, true, cl);
                    boolean present = lc.isAnnotationPresent(Iri.class);
                    for (String rdf : types.split("\\s+")) {
                        if (rdf.length() == 0 && present) {
                            rdf = lc.getAnnotation(Iri.class).value();
                            this.recordType(lc, URIs.createURI((String)rdf));
                            continue;
                        }
                        if (rdf.length() == 0) {
                            this.logger.warn("Unkown datatype mapping {}", (Object)className);
                            continue;
                        }
                        this.recordType(lc, URIs.createURI((String)rdf));
                    }
                }
            }
            catch (IOException e) {
                String msg = e.getMessage() + " in: " + url;
                IOException ioe = new IOException(msg);
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    public void recordType(Class<?> javaClass, URI datatype) {
        if (!this.javaClasses.containsKey(datatype)) {
            this.javaClasses.putIfAbsent(datatype, javaClass);
        }
        if (this.rdfTypes.putIfAbsent(javaClass, datatype) == null) {
            IConverter<?> converter = this.findConverter(javaClass);
            converter.setDatatype(datatype);
        }
    }

    public void registerConverter(Class<?> javaClass, IConverter<?> converter) {
        this.registerConverter(javaClass.getName(), converter);
    }

    private void registerConverter(IConverter<?> converter) {
        this.registerConverter(converter.getJavaClassName(), converter);
    }

    public void registerConverter(String javaClassName, IConverter<?> converter) {
        this.injector.injectMembers(converter);
        this.converters.put(javaClassName, converter);
    }

    @Inject
    protected void setClassLoaderAndInjector(final ClassLoader cl, Injector injector) {
        this.cl = cl;
        this.injector = injector = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
            }

            @Provides
            protected DatatypeFactory provideDatatypeFactory() throws DatatypeConfigurationException {
                ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(cl);
                    DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
                    return datatypeFactory;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldTCCL);
                }
            }
        }});
        try {
            this.registerConverter(new BigDecimalConverter());
            this.registerConverter(new BigIntegerConverter());
            this.registerConverter(new BooleanConverter());
            this.registerConverter(new ByteConverter());
            this.registerConverter(new DoubleConverter());
            this.registerConverter(new FloatConverter());
            this.registerConverter(new IntegerConverter());
            this.registerConverter(new LongConverter());
            this.registerConverter(new ShortConverter());
            this.registerConverter(new CharacterConverter());
            this.registerConverter(new DateConverter());
            this.registerConverter(new LocaleConverter());
            this.registerConverter(new PatternConverter());
            this.registerConverter(new QNameConverter());
            this.registerConverter(new GregorianCalendarConverter());
            this.registerConverter(new SqlDateConverter());
            this.registerConverter(new SqlTimeConverter());
            this.registerConverter(new SqlTimestampConverter());
            this.registerConverter(new ClassConverter());
            DurationConverter dm = (DurationConverter)injector.getInstance(DurationConverter.class);
            this.registerConverter(dm.getJavaClassName(), dm);
            this.registerConverter(Duration.class, dm);
            XMLGregorianCalendarConverter xgcm = (XMLGregorianCalendarConverter)injector.getInstance(XMLGregorianCalendarConverter.class);
            this.registerConverter(xgcm.getJavaClassName(), xgcm);
            this.registerConverter(XMLGregorianCalendar.class, xgcm);
            this.registerConverter(new StringConverter("org.codehaus.groovy.runtime.GStringImpl"));
            this.registerConverter(new StringConverter("groovy.lang.GString$1"));
            this.registerConverter(new StringConverter("groovy.lang.GString$2"));
            this.registerConverter(new StringConverter("java.lang.String", RDF.TYPE_XMLLITERAL));
            this.loadDatatypes(this.getClass().getClassLoader(), DATATYPES_PROPERTIES);
            this.loadDatatypes(cl, DATATYPES_PROPERTIES);
        }
        catch (Exception e) {
            throw new ObjectConversionException((Throwable)e);
        }
    }
}

