/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.composition.properties.exceptions.ObjectConversionException;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class ClassConverter
implements IConverter<Class<?>> {
    private static final URI DATATYPE = URIs.createURI((String)("java:" + Class.class.getName()));
    @Inject
    private ILiteralFactory lf;
    @Inject
    private ClassLoader cl;
    private URI datatype = DATATYPE;

    @Override
    public String getJavaClassName() {
        return Class.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Class<?> deserialize(String label) {
        try {
            return Class.forName(label, true, this.cl);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectConversionException((Throwable)e);
        }
    }

    @Override
    public ILiteral serialize(Class<?> object) {
        return this.lf.createLiteral(object.getName(), this.datatype, null);
    }
}

