/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class LocaleConverter
implements IConverter<Locale> {
    @Inject
    private ILiteralFactory lf;
    private URI datatype = XMLSCHEMA.TYPE_LANGUAGE;
    private ConcurrentMap<String, Locale> locales = new ConcurrentHashMap<String, Locale>();

    @Override
    public String getJavaClassName() {
        return Locale.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Locale deserialize(String lang) {
        Locale locale = (Locale)this.locales.get(lang);
        if (locale == null) {
            String[] l = lang.split("-", 3);
            String language = l.length < 1 ? "" : l[0];
            String country = l.length < 2 ? "" : l[1];
            String variant = l.length < 3 ? "" : l[2];
            locale = new Locale(language, country.toUpperCase(), variant);
            Locale o = this.locales.putIfAbsent(lang, locale);
            if (o != null) {
                locale = o;
            }
        }
        return locale;
    }

    @Override
    public ILiteral serialize(Locale object) {
        String label = object.toString().toLowerCase().replace('_', '-');
        return this.lf.createLiteral(label, this.datatype, null);
    }
}

