/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.util.regex.Pattern;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class PatternConverter
implements IConverter<Pattern> {
    private static final URI DATATYPE = URIs.createURI((String)("java:" + Pattern.class.getName()));
    @Inject
    private ILiteralFactory lf;
    private URI datatype = DATATYPE;

    @Override
    public String getJavaClassName() {
        return Pattern.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Pattern deserialize(String label) {
        return Pattern.compile(label);
    }

    @Override
    public ILiteral serialize(Pattern object) {
        return this.lf.createLiteral(object.toString(), this.datatype, null);
    }
}

