/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import javax.xml.namespace.QName;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class QNameConverter
implements IConverter<QName> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return QName.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_QNAME;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public QName deserialize(String label) {
        int idx = label.indexOf(58);
        if (label.charAt(0) == '{' || idx < 0) {
            return QName.valueOf(label);
        }
        String prefix = label.substring(0, idx);
        return new QName("", label.substring(idx + 1), prefix);
    }

    @Override
    public ILiteral serialize(QName object) {
        if (object.getPrefix().length() == 0) {
            return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
        }
        StringBuilder label = new StringBuilder();
        label.append(object.getPrefix());
        label.append(":");
        label.append(object.getLocalPart());
        return this.lf.createLiteral(label.toString(), this.getDatatype(), null);
    }
}

