/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.sql.Time;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class SqlTimeConverter
implements IConverter<Time> {
    private static final URI DATATYPE = URIs.createURI((String)("java:" + Time.class.getName()));
    @Inject
    private ILiteralFactory lf;
    @Inject
    private DatatypeFactory factory;
    private URI datatype = DATATYPE;

    @Override
    public String getJavaClassName() {
        return Time.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Time deserialize(String label) {
        XMLGregorianCalendar gc = this.factory.newXMLGregorianCalendar(label);
        return new Time(gc.toGregorianCalendar().getTimeInMillis());
    }

    @Override
    public ILiteral serialize(Time object) {
        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
        gc.setTime(object);
        String label = this.factory.newXMLGregorianCalendar(gc).toXMLFormat();
        return this.lf.createLiteral(label, this.datatype, null);
    }
}

