/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class SqlTimestampConverter
implements IConverter<Timestamp> {
    private static final URI DATATYPE = URIs.createURI((String)("java:" + Timestamp.class.getName()));
    @Inject
    private ILiteralFactory lf;
    @Inject
    private DatatypeFactory factory;
    private URI datatype = DATATYPE;

    @Override
    public String getJavaClassName() {
        return Timestamp.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Timestamp deserialize(String label) {
        XMLGregorianCalendar gc = this.factory.newXMLGregorianCalendar(label);
        return new Timestamp(gc.toGregorianCalendar().getTimeInMillis());
    }

    @Override
    public ILiteral serialize(Timestamp object) {
        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
        gc.setTime(object);
        XMLGregorianCalendar xgc = this.factory.newXMLGregorianCalendar(gc);
        BigDecimal fraction = BigDecimal.valueOf(object.getNanos(), 9);
        xgc.setFractionalSecond(fraction);
        String label = xgc.toXMLFormat();
        return this.lf.createLiteral(label, this.datatype, null);
    }
}

