/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;

public class StringConverter
implements IConverter<Object> {
    @Inject
    private ILiteralFactory lf;
    private String className;
    private URI datatype;

    public StringConverter() {
        this(String.class.getName());
    }

    public StringConverter(String className) {
        this.className = className;
    }

    public StringConverter(String className, URI datatype) {
        this(className);
        this.datatype = datatype;
    }

    @Override
    public String getJavaClassName() {
        return this.className;
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Object deserialize(String label) {
        return label;
    }

    @Override
    public ILiteral serialize(Object object) {
        return this.lf.createLiteral(object.toString(), this.datatype, null);
    }
}

