/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.enilink.composition.properties.exceptions.ObjectConversionException;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class ValueOfConverter<T>
implements IConverter<T> {
    @Inject
    private ILiteralFactory lf;
    private Method valueOfMethod;
    private URI datatype;

    public ValueOfConverter(Class<T> type) throws NoSuchMethodException {
        this.datatype = URIs.createURI((String)("java:" + type.getName()));
        try {
            this.valueOfMethod = type.getDeclaredMethod("valueOf", String.class);
            if (!Modifier.isStatic(this.valueOfMethod.getModifiers())) {
                throw new NoSuchMethodException("valueOf Method is not static");
            }
            if (!type.equals(this.valueOfMethod.getReturnType())) {
                throw new NoSuchMethodException("Invalid return type");
            }
        }
        catch (NoSuchMethodException e) {
            try {
                this.valueOfMethod = type.getDeclaredMethod("getInstance", String.class);
                if (!Modifier.isStatic(this.valueOfMethod.getModifiers())) {
                    throw new NoSuchMethodException("getInstance Method is not static");
                }
                if (!type.equals(this.valueOfMethod.getReturnType())) {
                    throw new NoSuchMethodException("Invalid return type");
                }
            }
            catch (NoSuchMethodException e2) {
                throw e;
            }
        }
    }

    @Override
    public String getJavaClassName() {
        return this.valueOfMethod.getDeclaringClass().getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public T deserialize(String label) {
        try {
            return (T)this.valueOfMethod.invoke(null, label);
        }
        catch (Exception e) {
            throw new ObjectConversionException((Throwable)e);
        }
    }

    @Override
    public ILiteral serialize(T object) {
        return this.lf.createLiteral(object.toString(), this.datatype, null);
    }
}

