/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.common.cache.Cache;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.composition.asm.BehaviourMethodProcessor;
import net.enilink.composition.cache.IPropertyCache;
import net.enilink.composition.cache.behaviours.CacheBehaviourMethodProcessor;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.DecoratingEntityManagerModule;
import net.enilink.komma.em.internal.CachedEntity;
import net.enilink.komma.em.internal.CachingEntityManager;
import net.enilink.komma.em.internal.Fqn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingEntityManagerModule
extends DecoratingEntityManagerModule {
    @Override
    protected void configure() {
        super.configure();
        this.requireBinding((Key)new Key<Cache<Object, CachedEntity>>(){});
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), BehaviourMethodProcessor.class);
        multibinder.addBinding().to(CacheBehaviourMethodProcessor.class);
    }

    @Provides
    @Inject(optional=true)
    Fqn provideContextKey(@Named(value="modifyContexts") Set<URI> modifyContexts) {
        if (modifyContexts != null) {
            return new Fqn(modifyContexts.toArray());
        }
        return new Fqn(new Object[0]);
    }

    @Singleton
    @Provides
    IPropertyCache providePropertyCache(Cache<Object, CachedEntity> cache, Fqn contextKey) {
        return new PropertyCache(cache, contextKey);
    }

    @Override
    protected Class<? extends IEntityManager> getManagerClass() {
        return CachingEntityManager.class;
    }

    static class PropertyCache
    implements IPropertyCache {
        protected static Logger log = LoggerFactory.getLogger(PropertyCache.class);
        final Cache<Object, CachedEntity> cache;
        final Fqn contextKey;

        PropertyCache(Cache<Object, CachedEntity> cache, Fqn contextKey) {
            this.cache = cache;
            this.contextKey = contextKey;
        }

        public Object put(Object entity, Object property, Object[] parameters, Object value) {
            boolean isIterator = value instanceof Iterator;
            if (isIterator) {
                IteratorList itValues = new IteratorList();
                while (((Iterator)value).hasNext()) {
                    itValues.add(((Iterator)value).next());
                }
                value = itValues;
            }
            try {
                CachedEntity cached = (CachedEntity)this.cache.get(entity, CachedEntity.FACTORY);
                cached.put(this.contextKey, new Fqn(property, Arrays.asList(parameters)), value);
            }
            catch (ExecutionException e) {
                log.error("Error while caching property data.", (Throwable)e);
            }
            if (isIterator) {
                return WrappedIterator.create(((List)value).iterator());
            }
            return value;
        }

        public Object get(Object entity, Object property, Object[] parameters) {
            CachedEntity cached = (CachedEntity)this.cache.getIfPresent(entity);
            if (cached != null) {
                Object value = cached.get(this.contextKey, new Fqn(property, Arrays.asList(parameters)));
                boolean isIterator = value instanceof IteratorList;
                if (isIterator) {
                    return WrappedIterator.create(((List)value).iterator());
                }
                return value;
            }
            return null;
        }

        class IteratorList
        extends ArrayList<Object> {
            IteratorList() {
            }
        }
    }
}

