/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.ClassResolver;
import net.enilink.composition.CompositionModule;
import net.enilink.composition.DefaultObjectFactory;
import net.enilink.composition.ObjectFactory;
import net.enilink.composition.mappers.ComposedRoleMapper;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.composition.mappers.TypeFactory;
import net.enilink.composition.properties.PropertyMapper;
import net.enilink.composition.properties.behaviours.PropertyMapperProcessor;
import net.enilink.composition.properties.sparql.SparqlBehaviourMethodProcessor;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.LiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.internal.ByteArrayConverter;
import net.enilink.komma.em.internal.behaviours.EntitySupport;
import net.enilink.komma.literals.IConverter;
import net.enilink.komma.literals.LiteralConverter;
import net.enilink.vocab.rdfs.RDFS;

public class ManagerCompositionModule
extends AbstractModule {
    private static Map<ClassLoader, WeakReference<ClassLoader>> classLoaders = new WeakHashMap<ClassLoader, WeakReference<ClassLoader>>();
    private static Map<ClassLoader, WeakReference<ClassDefiner>> definers = new WeakHashMap<ClassLoader, WeakReference<ClassDefiner>>();
    private KommaModule module;

    public ManagerCompositionModule(KommaModule module) {
        this.module = module;
    }

    protected void configure() {
        this.install((Module)new CompositionModule<URI>(){

            protected void initBindings() {
                super.initBindings();
                this.getBehaviourClassProcessorBinder().addBinding().to(PropertyMapperProcessor.class).in(Singleton.class);
                this.getBehaviourMethodProcessorBinder().addBinding().to(SparqlBehaviourMethodProcessor.class).in(Singleton.class);
            }

            protected RoleMapper<URI> createRoleMapper(TypeFactory<URI> typeFactory) {
                return new ComposedRoleMapper(typeFactory);
            }

            protected void initRoleMapper(RoleMapper<URI> roleMapper, TypeFactory<URI> typeFactory) {
                super.initRoleMapper(roleMapper, typeFactory);
                for (KommaModule.Association e : ManagerCompositionModule.this.module.getAnnotations()) {
                    roleMapper.addAnnotation(e.getJavaClass(), typeFactory.createType(e.getRdfType()));
                }
                for (KommaModule.Association e : ManagerCompositionModule.this.module.getConcepts()) {
                    if (e.getRdfType() == null) {
                        roleMapper.addConcept(e.getJavaClass());
                        continue;
                    }
                    roleMapper.addConcept(e.getJavaClass(), typeFactory.createType(e.getRdfType()));
                }
                for (KommaModule.Association e : ManagerCompositionModule.this.module.getBehaviours()) {
                    if (e.getRdfType() == null) {
                        roleMapper.addBehaviour(e.getJavaClass());
                        continue;
                    }
                    roleMapper.addBehaviour(e.getJavaClass(), typeFactory.createType(e.getRdfType()));
                }
                roleMapper.addBehaviour(EntitySupport.class, (Object)RDFS.TYPE_RESOURCE);
            }

            protected void bindClassDefiner() {
            }
        });
        this.bind((Key)new Key<ObjectFactory<URI>>(){}).to((TypeLiteral)new TypeLiteral<DefaultObjectFactory<URI>>(){});
        this.bind((TypeLiteral)new TypeLiteral<ClassResolver<URI>>(){}).in(Singleton.class);
    }

    @Provides
    @Singleton
    protected TypeFactory<URI> provideTypeFactory() {
        return new TypeFactory<URI>(){

            public URI createType(String type) {
                return URIs.createURI((String)type);
            }

            public String toString(URI type) {
                return type.toString();
            }
        };
    }

    @Provides
    @Singleton
    protected PropertyMapper providePropertyMapper(ClassLoader cl) {
        return new PropertyMapper(cl, true);
    }

    @Provides
    @Singleton
    protected ClassLoader provideClassLoader() {
        return this.module.getClassLoader();
    }

    @Provides
    @Singleton
    protected LiteralConverter provideLiteralConverter(Injector injector) {
        LiteralConverter literalConverter = new LiteralConverter();
        injector.injectMembers((Object)literalConverter);
        for (KommaModule.Association e : this.module.getDatatypes()) {
            literalConverter.addDatatype(e.getJavaClass(), URIs.createURI((String)e.getRdfType()));
        }
        ByteArrayConverter converter = new ByteArrayConverter();
        literalConverter.registerConverter(converter.getJavaClassName(), (IConverter)converter);
        literalConverter.recordType(byte[].class, converter.getDatatype());
        return literalConverter;
    }

    @Provides
    @Singleton
    protected ILiteralFactory provideLiteralFactory() {
        return new LiteralFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provides
    @Singleton
    protected ClassDefiner provideSharedClassDefiner(ClassLoader cl) {
        ClassDefiner definer = null;
        Map<ClassLoader, WeakReference<ClassDefiner>> map = definers;
        synchronized (map) {
            WeakReference<ClassDefiner> ref = definers.get(cl);
            if (ref != null) {
                definer = (ClassDefiner)ref.get();
            }
            if (definer == null) {
                ClassLoader internedLoader = null;
                Map<ClassLoader, WeakReference<ClassLoader>> map2 = classLoaders;
                synchronized (map2) {
                    Reference loaderRef = classLoaders.get(cl);
                    if (loaderRef != null) {
                        internedLoader = (ClassLoader)loaderRef.get();
                    }
                    if (internedLoader == null) {
                        classLoaders.put(internedLoader, new WeakReference<ClassLoader>(internedLoader));
                        internedLoader = cl;
                    }
                }
                definer = new ClassDefiner(internedLoader);
                definers.put(internedLoader, new WeakReference<ClassDefiner>(definer));
            }
        }
        return definer;
    }
}

