/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em;

import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityDecorator;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.em.DelegatingEntityManager;
import net.enilink.komma.em.internal.behaviours.IEntityManagerAware;
import net.enilink.komma.em.util.UnitOfWork;

public abstract class ThreadLocalEntityManager
extends DelegatingEntityManager {
    private ThreadLocal<IEntityManager> delegate = new ThreadLocal();
    private IEntityDecorator managerInjector = new IEntityDecorator(){

        public void decorate(IEntity entity) {
            ((IEntityManagerAware)entity).initEntityManager(ThreadLocalEntityManager.this);
        }
    };
    private List<IEntityDecorator> decorators = new CopyOnWriteArrayList<IEntityDecorator>();
    @Inject
    protected UnitOfWork uow;

    @Override
    public void addDecorator(IEntityDecorator decorator) {
        this.decorators.add(decorator);
        if (this.delegate.get() != null) {
            this.delegate.get().addDecorator(decorator);
        }
    }

    @Override
    public void close() {
        IEntityManager manager = this.delegate.get();
        if (manager != null) {
            manager.close();
            this.delegate.remove();
        }
    }

    protected abstract IEntityManager initialValue();

    @Override
    public IEntityManager getDelegate() {
        IEntityManager manager = this.delegate.get();
        if (manager == null || !manager.isOpen()) {
            if (!this.uow.isActive()) {
                throw new KommaException("No active unit of work found.");
            }
            manager = this.initialValue();
            for (IEntityDecorator decorator : this.decorators) {
                manager.addDecorator(decorator);
            }
            manager.addDecorator(this.managerInjector);
            this.uow.addCloseable((AutoCloseable)((Object)this));
            this.delegate.set(manager);
        }
        return manager;
    }

    @Override
    public boolean isOpen() {
        IEntityManager manager = this.delegate.get();
        return manager != null ? manager.isOpen() : false;
    }

    @Override
    public void removeDecorator(IEntityDecorator decorator) {
        this.decorators.remove(decorator);
        if (this.delegate.get() != null) {
            this.delegate.get().removeDecorator(decorator);
        }
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }
}

