/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.concepts;

import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IResultDescriptor;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.concepts.BehaviorBase;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.em.concepts.ResourceSupport;
import net.enilink.komma.em.results.ResultDescriptor;
import net.enilink.vocab.komma.KOMMA;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdfs.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassSupport
extends BehaviorBase
implements IClass,
Behaviour<IClass> {
    private static Logger log = LoggerFactory.getLogger(ClassSupport.class);
    private static final String SELECT_INSTANCES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?instance WHERE { ?instance a ?class .}";
    private static final String SELECT_DECLARED_PROPERTIES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?property WHERE { ?property rdfs:domain ?class .} ORDER BY ?property";
    private static final String HAS_DECLARED_PROPERTIES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?property rdfs:domain ?class .}";

    private final String SELECT_DIRECT_SUBCLASSES(boolean named) {
        StringBuilder sb = new StringBuilder("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ");
        sb.append("SELECT ?subClass WHERE { ");
        if (RDFS.TYPE_RESOURCE.equals((Object)this) || OWL.TYPE_THING.equals((Object)this)) {
            sb.append("{ ?subClass a ").append(RDFS.TYPE_RESOURCE.equals((Object)this) ? "rdfs:Class" : "owl:Class").append(" . ");
            sb.append("MINUS { ?subClass rdfs:subClassOf ?someSuperClass . { ?someSuperClass a rdfs:Class } UNION { ?someSuperClass a owl:Class } ").append("FILTER (isIRI(?someSuperClass) && ?someSuperClass != ?subClass && ?someSuperClass != owl:Thing && ?someSuperClass != rdfs:Resource) } }");
            sb.append(" UNION { ?subClass rdfs:subClassOf ?superClass }");
        } else {
            sb.append("?subClass rdfs:subClassOf ?superClass . ");
        }
        sb.append("FILTER NOT EXISTS {").append("?subClass rdfs:subClassOf ?otherSuperClass . ").append("?otherSuperClass rdfs:subClassOf ?superClass  . ").append("FILTER (").append(named ? "isIRI(?otherSuperClass) && " : "").append("?subClass != ?otherSuperClass && ?superClass != ?otherSuperClass)").append("}").append(" FILTER (" + (named ? "isIRI(?subClass) && " : "")).append("?subClass != ?superClass && ?subClass != owl:Nothing)}").append("ORDER BY ?subClass");
        return sb.toString();
    }

    private final String SELECT_SUBCLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?subClass WHERE { " + (OWL.TYPE_THING.equals((Object)this) ? "?subClass a owl:Class . " : "?subClass rdfs:subClassOf ?superClass . ") + "FILTER (?subClass != ?superClass" + (named ? " && isIRI(?subClass)" : "") + ") } ORDER BY ?subClass";
    }

    private static final String SELECT_LEAF_SUBCLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?subClass WHERE { ?subClass rdfs:subClassOf* ?superClass . OPTIONAL {?otherSubClass rdfs:subClassOf ?subClass . FILTER (?subClass != ?otherSubClass)} FILTER (" + (named ? "isIRI(?subClass) && " : "") + "!bound(?otherSubClass)) } ORDER BY ?subClass";
    }

    private static final String SELECT_DIRECT_SUPERCLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?superClass WHERE { ?subClass rdfs:subClassOf ?superClass . FILTER NOT EXISTS { ?superClass a owl:Restriction } FILTER NOT EXISTS {?subClass rdfs:subClassOf ?otherSuperClass . ?otherSuperClass rdfs:subClassOf ?superClass . FILTER (?subClass != ?otherSuperClass && ?superClass != ?otherSuperClass" + (named ? " && isIRI(?otherSuperClass)" : "") + ")} FILTER (?subClass != ?superClass" + (named ? "&& isIRI(?superClass)" : "") + ") } ORDER BY ?superClass";
    }

    private static final String SELECT_SUPERCLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?superClass WHERE { ?subClass rdfs:subClassOf ?superClass . FILTER NOT EXISTS {?superClass a owl:Restriction}FILTER (?subClass != ?superClass" + (named ? "&& isIRI(?subClass)" : "") + ") } ORDER BY ?superClass";
    }

    private static final String HAS_SUBCLASSES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?subClass rdfs:subClassOf ?superClass . FILTER (" + (named ? "isIRI(?subClass) && " : "") + "?subClass != ?superClass && ?subClass != owl:Nothing)}";
    }

    public static final IResultDescriptor<?> HAS_NAMED_SUBCLASSES_DESC() {
        return new ResultDescriptor(ClassSupport.HAS_SUBCLASSES(true), "komma:hasNamedSubClasses", "subClass", "superClass");
    }

    public static final IResultDescriptor<?> DIRECT_NAMED_SUPERCLASSES_DESC() {
        return new ResultDescriptor(ClassSupport.SELECT_DIRECT_SUPERCLASSES(true), "komma:directNamedSuperClasses", "superClass", "subClass");
    }

    @Override
    public IExtendedIterator<IResource> getInstances() {
        IQuery query = this.getEntityManager().createQuery(SELECT_INSTANCES);
        query.setParameter("class", (Object)this);
        return query.evaluate(IResource.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IReference> getInstancesAsReferences() {
        IQuery query = this.getEntityManager().createQuery(SELECT_INSTANCES);
        query.setParameter("class", (Object)this);
        return query.evaluateRestricted(IReference.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IClass> getDirectNamedSubClasses() {
        return this.getSubClasses(true, false, true);
    }

    @Override
    public IExtendedIterator<IClass> getNamedSubClasses() {
        return this.getSubClasses(false, true, true);
    }

    @Override
    public IExtendedIterator<IClass> getSubClasses(boolean direct, boolean includeInferred) {
        return this.getSubClasses(direct, includeInferred, false);
    }

    protected IExtendedIterator<IClass> getSubClasses(boolean direct, boolean includeInferred, boolean named) {
        String queryString = direct ? this.SELECT_DIRECT_SUBCLASSES(named) : this.SELECT_SUBCLASSES(named);
        if (named) {
            queryString = new ResultDescriptor(queryString).prefetch(ClassSupport.HAS_NAMED_SUBCLASSES_DESC()).prefetch(ResourceSupport.DIRECT_NAMED_CLASSES_DESC()).toQueryString();
        }
        IQuery query = this.getEntityManager().createQuery(queryString, includeInferred);
        query.setParameter("superClass", (Object)this);
        return query.evaluate(IClass.class, new Class[0]);
    }

    @Override
    public Boolean hasNamedSubClasses() {
        return ((IQuery)this.getEntityManager().createQuery(ClassSupport.HAS_NAMED_SUBCLASSES_DESC().toQueryString()).setParameter("superClass", (Object)this)).getBooleanResult();
    }

    @Override
    public IExtendedIterator<IClass> getNamedLeafSubClasses(boolean includeInferred) {
        return this.getLeafSubClasses(includeInferred, true);
    }

    @Override
    public IExtendedIterator<IClass> getLeafSubClasses(boolean includeInferred) {
        return this.getLeafSubClasses(includeInferred, false);
    }

    protected IExtendedIterator<IClass> getLeafSubClasses(boolean includeInferred, boolean named) {
        IQuery query = this.getEntityManager().createQuery(ClassSupport.SELECT_LEAF_SUBCLASSES(named), includeInferred);
        query.setParameter("superClass", this.getBehaviourDelegate());
        return query.evaluate(IClass.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IClass> getDirectNamedSuperClasses() {
        log.info("Get super classes for {}", this.getBehaviourDelegate());
        return ((IQuery)this.getEntityManager().createQuery(ClassSupport.DIRECT_NAMED_SUPERCLASSES_DESC().toQueryString(), false).setParameter("subClass", this.getBehaviourDelegate())).evaluate(IClass.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IClass> getNamedSuperClasses() {
        return this.getSuperClasses(false, true, true);
    }

    @Override
    public IExtendedIterator<IClass> getSuperClasses(boolean direct, boolean includeInferred) {
        return this.getSuperClasses(direct, includeInferred, false);
    }

    protected IExtendedIterator<IClass> getSuperClasses(boolean direct, boolean includeInferred, boolean named) {
        if (direct && named) {
            return ((IClass)this.getBehaviourDelegate()).getDirectNamedSuperClasses();
        }
        IQuery query = this.getEntityManager().createQuery(direct ? ClassSupport.SELECT_DIRECT_SUPERCLASSES(named) : ClassSupport.SELECT_SUPERCLASSES(named), includeInferred);
        query.setParameter("subClass", this.getBehaviourDelegate());
        return query.evaluate(IClass.class, new Class[0]);
    }

    @Override
    public boolean hasNamedSubClasses(boolean includeInferred) {
        return this.hasSubClasses(includeInferred, true);
    }

    @Override
    public boolean hasSubClasses(boolean includeInferred) {
        return this.hasSubClasses(includeInferred, false);
    }

    protected boolean hasSubClasses(boolean includeInferred, boolean named) {
        if (named) {
            return ((IClass)this.getBehaviourDelegate()).hasNamedSubClasses();
        }
        try {
            IQuery query = this.getEntityManager().createQuery(ClassSupport.HAS_SUBCLASSES(named), includeInferred);
            query.setParameter("superClass", (Object)this);
            return query.getBooleanResult();
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    @Override
    public boolean hasDeclaredProperties(boolean includeInferred) {
        try {
            IQuery query = this.getEntityManager().createQuery(HAS_DECLARED_PROPERTIES, includeInferred);
            query.setParameter("class", (Object)this);
            return query.getBooleanResult();
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    @Override
    public IExtendedIterator<IProperty> getDeclaredProperties(boolean includeInferred) {
        IQuery query = this.getEntityManager().createQuery(SELECT_DECLARED_PROPERTIES, includeInferred);
        query.setParameter("class", this.getBehaviourDelegate());
        return query.evaluate();
    }

    @Override
    public IResource newInstance() {
        return this.newInstance(null);
    }

    @Override
    public IResource newInstance(URI uri) {
        if (uri == null) {
            return (IResource)this.getEntityManager().create(new IReference[]{(IReference)this.getBehaviourDelegate()});
        }
        return (IResource)this.getEntityManager().createNamed(uri, new IReference[]{(IReference)this.getBehaviourDelegate()});
    }

    @Override
    public boolean isAbstract() {
        return this.getAsSet((IReference)KOMMA.PROPERTY_ISABSTRACT).contains(Boolean.TRUE);
    }
}

